/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.catalog.files.api.BackendExceptionMapper;
import org.projectnessie.catalog.files.api.ObjectIO;
import org.projectnessie.catalog.formats.iceberg.IcebergSpec;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergJson;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergTableMetadata;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergViewMetadata;
import org.projectnessie.catalog.formats.iceberg.nessie.IcebergTableMetadataUpdateState;
import org.projectnessie.catalog.formats.iceberg.nessie.IcebergViewMetadataUpdateState;
import org.projectnessie.catalog.formats.iceberg.nessie.NessieModelIceberg;
import org.projectnessie.catalog.formats.iceberg.rest.IcebergCatalogOperation;
import org.projectnessie.catalog.formats.iceberg.rest.IcebergMetadataUpdate;
import org.projectnessie.catalog.formats.iceberg.rest.IcebergUpdateRequirement;
import org.projectnessie.catalog.model.id.NessieId;
import org.projectnessie.catalog.model.ops.CatalogOperation;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.catalog.model.snapshot.NessieTableSnapshot;
import org.projectnessie.catalog.model.snapshot.NessieViewSnapshot;
import org.projectnessie.catalog.service.api.CatalogCommit;
import org.projectnessie.catalog.service.api.CatalogEntityAlreadyExistsException;
import org.projectnessie.catalog.service.api.CatalogService;
import org.projectnessie.catalog.service.api.NessieSnapshotResponse;
import org.projectnessie.catalog.service.api.SnapshotReqParams;
import org.projectnessie.catalog.service.api.SnapshotResponse;
import org.projectnessie.catalog.service.config.LakehouseConfig;
import org.projectnessie.catalog.service.config.ServiceConfig;
import org.projectnessie.catalog.service.config.WarehouseConfig;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskBehavior;
import org.projectnessie.catalog.service.impl.IcebergStuff;
import org.projectnessie.catalog.service.impl.MultiTableUpdate;
import org.projectnessie.catalog.service.impl.Util;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Reference;
import org.projectnessie.nessie.tasks.api.TasksService;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.ApiContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.storage.uri.StorageUri;
import org.projectnessie.versioned.RequestMeta;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class CatalogServiceImpl
implements CatalogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogServiceImpl.class);
    @Inject
    ObjectIO objectIO;
    @Inject
    ServerConfig serverConfig;
    @Inject
    LakehouseConfig lakehouseConfig;
    @Inject
    VersionStore versionStore;
    @Inject
    Authorizer authorizer;
    @Inject
    AccessContext accessContext;
    @Inject
    Persist persist;
    @Inject
    TasksService tasksService;
    @Inject
    BackendExceptionMapper backendExceptionMapper;
    @Inject
    ServiceConfig serviceConfig;
    @Inject
    @Named(value="import-jobs")
    Executor executor;

    TreeService treeService(ApiContext apiContext) {
        return new TreeApiImpl(this.serverConfig, this.versionStore, this.authorizer, this.accessContext, apiContext);
    }

    ContentService contentService(ApiContext apiContext) {
        return new ContentApiImpl(this.serverConfig, this.versionStore, this.authorizer, this.accessContext, apiContext);
    }

    private IcebergStuff icebergStuff() {
        return new IcebergStuff(this.objectIO, this.persist, this.tasksService, new EntitySnapshotTaskBehavior(this.backendExceptionMapper, this.serviceConfig.effectiveRetryAfterThrottled()), this.executor);
    }

    public Optional<String> validateStorageLocation(String location) {
        StorageUri uri = StorageUri.of((String)location);
        return this.objectIO.canResolve(uri);
    }

    public StorageUri locationForEntity(WarehouseConfig warehouse, ContentKey contentKey, Content.Type contentType, ApiContext apiContext, String refName, String hash) {
        GetMultipleContentsResponse namespaces;
        List keyElements = contentKey.getElements();
        int keyElementCount = keyElements.size();
        ArrayList<ContentKey> keysInOrder = new ArrayList<ContentKey>(keyElementCount);
        for (int i = 0; i < keyElementCount; ++i) {
            ContentKey key = ContentKey.of(keyElements.subList(0, i + 1));
            keysInOrder.add(key);
        }
        try {
            namespaces = this.contentService(apiContext).getMultipleContents(refName, hash, keysInOrder, false, RequestMeta.API_READ);
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
        Map contentsMap = namespaces.toContentsMap();
        return this.locationForEntity(warehouse, contentKey, keysInOrder, contentsMap);
    }

    public StorageUri locationForEntity(WarehouseConfig warehouse, ContentKey contentKey, List<ContentKey> keysInOrder, Map<ContentKey, Content> contentsMap) {
        List keyElements = contentKey.getElements();
        int keyElementCount = keyElements.size();
        StorageUri location = null;
        List remainingElements = List.of();
        for (int n = keysInOrder.size() - 1; n >= 0; --n) {
            Namespace parentNamespace;
            String parentLocation;
            Content parent = contentsMap.get(keysInOrder.get(n));
            if (parent == null || !parent.getType().equals((Object)Content.Type.NAMESPACE) || (parentLocation = (String)(parentNamespace = (Namespace)parent).getProperties().get("location")) == null) continue;
            location = StorageUri.of((String)parentLocation).withTrailingSeparator();
            remainingElements = keyElements.subList(n + 1, keyElementCount);
        }
        if (location == null) {
            location = StorageUri.of((String)warehouse.location()).withTrailingSeparator();
            remainingElements = keyElements;
        }
        for (String element : remainingElements) {
            location = location.withTrailingSeparator().resolve(element);
        }
        return location;
    }

    public Stream<Supplier<CompletionStage<SnapshotResponse>>> retrieveSnapshots(SnapshotReqParams reqParams, List<ContentKey> keys, Consumer<Reference> effectiveReferenceConsumer, RequestMeta requestMeta, ApiContext apiContext) throws NessieNotFoundException {
        ParsedReference reference = reqParams.ref();
        LOGGER.trace("retrieveTableSnapshots ref-name:{} ref-hash:{} keys:{}", new Object[]{reference.name(), reference.hashWithRelativeSpec(), keys});
        GetMultipleContentsResponse contentResponse = this.contentService(apiContext).getMultipleContents(reference.name(), reference.hashWithRelativeSpec(), keys, false, requestMeta);
        IcebergStuff icebergStuff = this.icebergStuff();
        Reference effectiveReference = contentResponse.getEffectiveReference();
        effectiveReferenceConsumer.accept(effectiveReference);
        return contentResponse.getContents().stream().map(c -> {
            ObjId snapshotId;
            try {
                snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)c.getContent());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to retrieve snapshot ID for {}: {}", (Object)c.getContent(), (Object)e.toString());
                return null;
            }
            return () -> {
                ContentKey key = c.getKey();
                LOGGER.trace("retrieveTableSnapshots - individual ref-name:{} ref-hash:{} key:{}", new Object[]{reference.name(), reference.hashWithRelativeSpec(), key});
                CompletionStage snapshotStage = icebergStuff.retrieveIcebergSnapshot(snapshotId, c.getContent());
                return snapshotStage.thenApply(snapshot -> this.snapshotResponse(key, c.getContent(), reqParams, (NessieEntitySnapshot<?>)snapshot, effectiveReference));
            };
        }).filter(Objects::nonNull);
    }

    public CompletionStage<SnapshotResponse> retrieveSnapshot(SnapshotReqParams reqParams, ContentKey key, @Nullable Content.Type expectedType, RequestMeta requestMeta, ApiContext apiContext) throws NessieNotFoundException {
        ParsedReference reference = reqParams.ref();
        LOGGER.trace("retrieveTableSnapshot ref-name:{} ref-hash:{} key:{}", new Object[]{reference.name(), reference.hashWithRelativeSpec(), key});
        ContentResponse contentResponse = this.contentService(apiContext).getContent(key, reference.name(), reference.hashWithRelativeSpec(), false, requestMeta);
        Content content = contentResponse.getContent();
        if (expectedType != null && !content.getType().equals((Object)expectedType)) {
            throw new NessieContentNotFoundException(key, reference.name());
        }
        Reference effectiveReference = contentResponse.getEffectiveReference();
        ObjId snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)content);
        CompletionStage snapshotStage = this.icebergStuff().retrieveIcebergSnapshot(snapshotId, content);
        return snapshotStage.thenApply(snapshot -> this.snapshotResponse(key, content, reqParams, (NessieEntitySnapshot<?>)snapshot, effectiveReference));
    }

    private SnapshotResponse snapshotResponse(ContentKey key, Content content, SnapshotReqParams reqParams, NessieEntitySnapshot<?> snapshot, Reference effectiveReference) {
        if (snapshot instanceof NessieTableSnapshot) {
            return this.snapshotTableResponse(key, content, reqParams, (NessieTableSnapshot)snapshot, effectiveReference);
        }
        if (snapshot instanceof NessieViewSnapshot) {
            return this.snapshotViewResponse(key, content, reqParams, (NessieViewSnapshot)snapshot, effectiveReference);
        }
        throw new IllegalArgumentException("Unsupported snapshot type " + snapshot.getClass().getSimpleName());
    }

    private SnapshotResponse snapshotTableResponse(ContentKey key, Content content, SnapshotReqParams reqParams, NessieTableSnapshot snapshot, Reference effectiveReference) {
        IcebergTableMetadata result;
        String fileName;
        switch (reqParams.snapshotFormat()) {
            case NESSIE_SNAPSHOT: {
                fileName = String.join((CharSequence)"/", key.getElements()) + "_" + snapshot.id().idAsString() + ".nessie-metadata.json";
                result = NessieSnapshotResponse.nessieSnapshotResponse((Reference)effectiveReference, (NessieEntitySnapshot)snapshot);
                break;
            }
            case ICEBERG_TABLE_METADATA: {
                result = NessieModelIceberg.nessieTableSnapshotToIceberg((NessieTableSnapshot)snapshot, CatalogServiceImpl.optionalIcebergSpec(reqParams.reqVersion()), this.metadataPropertiesTweak((NessieEntitySnapshot<?>)snapshot, effectiveReference));
                fileName = "00000-" + snapshot.id().idAsString() + ".metadata.json";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + String.valueOf(reqParams.snapshotFormat()));
            }
        }
        return SnapshotResponse.forEntity((Reference)effectiveReference, (Object)result, (String)fileName, (String)"application/json", (ContentKey)key, (Content)content, (NessieEntitySnapshot)snapshot);
    }

    private Consumer<Map<String, String>> metadataPropertiesTweak(NessieEntitySnapshot<?> snapshot, Reference effectiveReference) {
        return properties -> {
            properties.put("nessie.catalog.content-id", snapshot.entity().nessieContentId());
            properties.put("nessie.commit.id", effectiveReference.getHash());
            properties.put("nessie.commit.ref", effectiveReference.getName());
        };
    }

    private SnapshotResponse snapshotViewResponse(ContentKey key, Content content, SnapshotReqParams reqParams, NessieViewSnapshot snapshot, Reference effectiveReference) {
        IcebergViewMetadata result;
        String fileName;
        switch (reqParams.snapshotFormat()) {
            case NESSIE_SNAPSHOT: {
                fileName = String.join((CharSequence)"/", key.getElements()) + "_" + snapshot.id().idAsString() + ".nessie-metadata.json";
                result = NessieSnapshotResponse.nessieSnapshotResponse((Reference)effectiveReference, (NessieEntitySnapshot)snapshot);
                break;
            }
            case ICEBERG_TABLE_METADATA: {
                result = NessieModelIceberg.nessieViewSnapshotToIceberg((NessieViewSnapshot)snapshot, CatalogServiceImpl.optionalIcebergSpec(reqParams.reqVersion()), this.metadataPropertiesTweak((NessieEntitySnapshot<?>)snapshot, effectiveReference));
                fileName = "00000-" + snapshot.id().idAsString() + ".metadata.json";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + String.valueOf(reqParams.snapshotFormat()));
            }
        }
        return SnapshotResponse.forEntity((Reference)effectiveReference, (Object)result, (String)fileName, (String)"application/json", (ContentKey)key, (Content)content, (NessieEntitySnapshot)snapshot);
    }

    CompletionStage<MultiTableUpdate> commit(ParsedReference reference, CatalogCommit commit, Function<String, CommitMeta> commitMetaBuilder, String apiRequest, ApiContext apiContext) throws BaseNessieClientServerException {
        RequestMeta.RequestMetaBuilder requestMeta = RequestMeta.apiWrite();
        List allKeys = commit.getOperations().stream().map(CatalogOperation::getKey).collect(Collectors.toList());
        for (ContentKey key : allKeys) {
            requestMeta.addKeyAction(key, apiRequest);
        }
        GetMultipleContentsResponse contentsResponse = this.contentService(apiContext).getMultipleContents(reference.name(), reference.hashWithRelativeSpec(), allKeys, false, requestMeta.build());
        Preconditions.checkArgument((boolean)(Objects.requireNonNull(contentsResponse.getEffectiveReference()) instanceof Branch), (String)"Can only commit to a branch, but %s %s", (Object)contentsResponse.getEffectiveReference().getType(), (Object)reference.name());
        Branch target = Branch.of((String)reference.name(), (String)(reference.hashWithRelativeSpec() != null ? reference.hashWithRelativeSpec() : contentsResponse.getEffectiveReference().getHash()));
        Map contents = contentsResponse.toContentsMap();
        IcebergStuff icebergStuff = this.icebergStuff();
        MultiTableUpdate multiTableUpdate = new MultiTableUpdate(this.treeService(apiContext), target, requestMeta);
        LOGGER.trace("Executing commit containing {} operations against '{}@{}'", new Object[]{commit.getOperations().size(), target.getName(), target.getHash()});
        CompletionStage<MultiTableUpdate> commitBuilderStage = CompletableFuture.completedStage(multiTableUpdate);
        StringBuilder message = new StringBuilder();
        if (commit.getOperations().size() > 1) {
            message.append("Catalog commit with ");
            message.append(commit.getOperations().size());
            message.append(" operations\n");
        }
        for (CatalogOperation op : commit.getOperations()) {
            Content content = (Content)contents.get(op.getKey());
            message.append(commit.getOperations().size() > 1 ? "\n* " : "").append(contents.containsKey(op.getKey()) ? "Update" : "Create").append(" ").append(op.getType()).append(" ").append(op.getKey());
            if (op.getType().equals((Object)Content.Type.ICEBERG_TABLE)) {
                CatalogServiceImpl.verifyIcebergOperation(op, reference, content);
                commitBuilderStage = this.applyIcebergTableCommitOperation(target, op, content, multiTableUpdate, commitBuilderStage, apiContext);
                continue;
            }
            if (op.getType().equals((Object)Content.Type.ICEBERG_VIEW)) {
                CatalogServiceImpl.verifyIcebergOperation(op, reference, content);
                commitBuilderStage = this.applyIcebergViewCommitOperation(target, op, content, multiTableUpdate, commitBuilderStage, apiContext);
                continue;
            }
            throw new IllegalArgumentException("(Yet) unsupported entity type: " + String.valueOf(op.getType()));
        }
        multiTableUpdate.operations().commitMeta(commitMetaBuilder.apply(message.toString()));
        return commitBuilderStage.thenApply(updates -> {
            try {
                return updates.commit();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                try {
                    this.objectIO.deleteObjects(multiTableUpdate.storedLocations().stream().map(StorageUri::of).collect(Collectors.toList()));
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
        }).thenCompose(updates -> {
            Map<ContentKey, String> addedContentsMap = updates.addedContentsMap();
            CompletionStage<Object> current = CompletableFuture.completedStage(null);
            for (MultiTableUpdate.SingleTableUpdate tableUpdate : updates.tableUpdates()) {
                Content content = tableUpdate.content;
                if (content.getId() == null) {
                    content = content.withId(addedContentsMap.get(tableUpdate.key));
                }
                NessieId snapshotId = Util.objIdToNessieId(EntitySnapshotObj.snapshotObjIdForContent((Content)content));
                CompletionStage<NessieEntitySnapshot> stage = icebergStuff.storeSnapshot(tableUpdate.snapshot.withId(snapshotId), content);
                current = current.thenCombine(stage, (snap1, snap2) -> snap1);
            }
            return current.thenApply(x -> updates);
        });
    }

    public CompletionStage<Stream<SnapshotResponse>> commit(ParsedReference reference, CatalogCommit commit, SnapshotReqParams reqParams, Function<String, CommitMeta> commitMetaBuilder, String apiRequest, ApiContext apiContext) throws BaseNessieClientServerException {
        return this.commit(reference, commit, commitMetaBuilder, apiRequest, apiContext).thenApply(updates -> updates.tableUpdates().stream().map(singleTableUpdate -> this.snapshotResponse(singleTableUpdate.key, singleTableUpdate.content, reqParams, singleTableUpdate.snapshot, (Reference)updates.targetBranch())));
    }

    private static void verifyIcebergOperation(CatalogOperation op, ParsedReference reference, Content content) throws NessieContentNotFoundException, NessieReferenceConflictException {
        IcebergCatalogOperation icebergOp = (IcebergCatalogOperation)op;
        boolean hasAssertCreate = icebergOp.hasRequirement(IcebergUpdateRequirement.AssertCreate.class);
        if (hasAssertCreate && content != null) {
            throw new CatalogEntityAlreadyExistsException(true, op.getType(), op.getKey(), content.getType());
        }
        if (!hasAssertCreate && content == null) {
            throw new NessieContentNotFoundException(op.getKey(), reference.name());
        }
        if (content != null && !op.getType().equals((Object)content.getType())) {
            String msg = String.format("Cannot update %s %s as a %s", NessieModelIceberg.typeToEntityName((Content.Type)content.getType()).toLowerCase(Locale.ROOT), op.getKey(), NessieModelIceberg.typeToEntityName((Content.Type)op.getType()).toLowerCase(Locale.ROOT));
            throw new NessieReferenceConflictException(ReferenceConflicts.referenceConflicts((Conflict)Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.PAYLOAD_DIFFERS, (ContentKey)op.getKey(), (String)msg)), msg, null);
        }
    }

    private CompletionStage<MultiTableUpdate> applyIcebergTableCommitOperation(Branch reference, CatalogOperation op, Content content, MultiTableUpdate multiTableUpdate, CompletionStage<MultiTableUpdate> commitBuilderStage, ApiContext apiContext) {
        CompletionStage<NessieTableSnapshot> snapshotStage;
        String contentId;
        IcebergCatalogOperation icebergOp = (IcebergCatalogOperation)op;
        if (content == null) {
            contentId = null;
            String icebergUuid = (String)icebergOp.getSingleUpdateValue(IcebergMetadataUpdate.AssignUUID.class, IcebergMetadataUpdate.AssignUUID::uuid);
            snapshotStage = CompletableFuture.completedStage(NessieModelIceberg.newIcebergTableSnapshot((String)icebergUuid));
        } else {
            contentId = content.getId();
            snapshotStage = this.loadExistingTableSnapshot(content);
        }
        CompletionStage<MultiTableUpdate.SingleTableUpdate> contentStage = snapshotStage.thenApply(nessieSnapshot -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Applying {} metadata updates with {} requirements to '{}' against {}@{}", new Object[]{icebergOp.updates().size(), icebergOp.requirements().size(), op.getKey(), reference.getName(), reference.getHash()});
            }
            return new IcebergTableMetadataUpdateState(nessieSnapshot, op.getKey(), content != null).checkRequirements(icebergOp.requirements()).applyUpdates(this.pruneUpdates(reference, icebergOp, content != null, apiContext));
        }).thenApply(updateState -> {
            NessieTableSnapshot nessieSnapshot = updateState.snapshot();
            String metadataJsonLocation = NessieModelIceberg.icebergMetadataJsonLocation((String)nessieSnapshot.icebergLocation());
            IcebergTableMetadata icebergMetadata = this.storeTableSnapshot(metadataJsonLocation, nessieSnapshot, multiTableUpdate);
            Content updated = NessieModelIceberg.icebergMetadataToContent((String)metadataJsonLocation, (IcebergTableMetadata)icebergMetadata, (String)contentId);
            ObjId snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)updated);
            nessieSnapshot = nessieSnapshot.withId(Util.objIdToNessieId(snapshotId));
            MultiTableUpdate.SingleTableUpdate singleTableUpdate = new MultiTableUpdate.SingleTableUpdate((NessieEntitySnapshot<?>)nessieSnapshot, updated, icebergOp.getKey(), updateState.catalogOps());
            multiTableUpdate.addUpdate(op.getKey(), singleTableUpdate);
            return singleTableUpdate;
        });
        commitBuilderStage = contentStage.thenCombine(commitBuilderStage, (singleTableUpdate, nothing) -> multiTableUpdate);
        return commitBuilderStage;
    }

    private CompletionStage<MultiTableUpdate> applyIcebergViewCommitOperation(Branch reference, CatalogOperation op, Content content, MultiTableUpdate multiTableUpdate, CompletionStage<MultiTableUpdate> commitBuilderStage, ApiContext apiContext) {
        CompletionStage<NessieViewSnapshot> snapshotStage;
        String contentId;
        IcebergCatalogOperation icebergOp = (IcebergCatalogOperation)op;
        if (content == null) {
            contentId = null;
            String icebergUuid = (String)icebergOp.getSingleUpdateValue(IcebergMetadataUpdate.AssignUUID.class, IcebergMetadataUpdate.AssignUUID::uuid);
            snapshotStage = CompletableFuture.completedStage(NessieModelIceberg.newIcebergViewSnapshot((String)icebergUuid));
        } else {
            contentId = content.getId();
            snapshotStage = this.loadExistingViewSnapshot(content);
        }
        CompletionStage<MultiTableUpdate.SingleTableUpdate> contentStage = snapshotStage.thenApply(nessieSnapshot -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Applying {} metadata updates with {} requirements to '{}' against {}@{}", new Object[]{icebergOp.updates().size(), icebergOp.requirements().size(), op.getKey(), reference.getName(), reference.getHash()});
            }
            return new IcebergViewMetadataUpdateState(nessieSnapshot, op.getKey(), content != null).checkRequirements(icebergOp.requirements()).applyUpdates(this.pruneUpdates(reference, icebergOp, content != null, apiContext));
        }).thenApply(updateState -> {
            NessieViewSnapshot nessieSnapshot = updateState.snapshot();
            String metadataJsonLocation = NessieModelIceberg.icebergMetadataJsonLocation((String)nessieSnapshot.icebergLocation());
            IcebergViewMetadata icebergMetadata = this.storeViewSnapshot(metadataJsonLocation, nessieSnapshot, multiTableUpdate);
            Content updated = NessieModelIceberg.icebergMetadataToContent((String)metadataJsonLocation, (IcebergViewMetadata)icebergMetadata, (String)contentId);
            ObjId snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)updated);
            nessieSnapshot = nessieSnapshot.withId(Util.objIdToNessieId(snapshotId));
            MultiTableUpdate.SingleTableUpdate singleTableUpdate = new MultiTableUpdate.SingleTableUpdate((NessieEntitySnapshot<?>)nessieSnapshot, updated, icebergOp.getKey(), updateState.catalogOps());
            multiTableUpdate.addUpdate(op.getKey(), singleTableUpdate);
            return singleTableUpdate;
        });
        commitBuilderStage = contentStage.thenCombine(commitBuilderStage, (singleTableUpdate, nothing) -> multiTableUpdate);
        return commitBuilderStage;
    }

    private List<IcebergMetadataUpdate> pruneUpdates(Branch reference, IcebergCatalogOperation op, boolean update, ApiContext apiContext) {
        if (update) {
            return op.updates();
        }
        List<IcebergMetadataUpdate> prunedUpdates = CatalogServiceImpl.pruneCreateUpdates(op.updates());
        String location = this.setLocationForCreate(reference, op, apiContext);
        prunedUpdates.add((IcebergMetadataUpdate)IcebergMetadataUpdate.SetLocation.setTrustedLocation((String)location));
        return prunedUpdates;
    }

    @VisibleForTesting
    String setLocationForCreate(Branch reference, IcebergCatalogOperation op, ApiContext apiContext) {
        return op.updates().stream().filter(IcebergMetadataUpdate.SetLocation.class::isInstance).map(IcebergMetadataUpdate.SetLocation.class::cast).map(IcebergMetadataUpdate.SetLocation::location).reduce((a, b) -> b).map(l -> {
            this.validateStorageLocation((String)l).ifPresent(msg -> {
                throw new IllegalArgumentException(String.format("Location for %s '%s' cannot be associated with any configured object storage location: %s", op.getType().name(), op.getKey(), msg));
            });
            return l;
        }).orElseGet(() -> {
            WarehouseConfig w = this.lakehouseConfig.catalog().getWarehouse(op.warehouse());
            return NessieModelIceberg.icebergNewEntityBaseLocation((String)this.locationForEntity(w, op.getKey(), op.getType(), apiContext, reference.getName(), reference.getHash()).toString());
        });
    }

    @VisibleForTesting
    static List<IcebergMetadataUpdate> pruneCreateUpdates(List<IcebergMetadataUpdate> updates) {
        return updates.stream().map(up -> {
            HashMap properties;
            if (up instanceof IcebergMetadataUpdate.SetProperties && (properties = ((IcebergMetadataUpdate.SetProperties)up).updates()).containsKey("nessie.staged")) {
                properties = new HashMap(properties);
                properties.remove("nessie.staged");
                if (properties.isEmpty()) {
                    return null;
                }
                return IcebergMetadataUpdate.SetProperties.setProperties(properties);
            }
            return up;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    private CompletionStage<NessieTableSnapshot> loadExistingTableSnapshot(Content content) {
        ObjId snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)content);
        return this.icebergStuff().retrieveIcebergSnapshot(snapshotId, content);
    }

    private CompletionStage<NessieViewSnapshot> loadExistingViewSnapshot(Content content) {
        ObjId snapshotId = EntitySnapshotObj.snapshotObjIdForContent((Content)content);
        return this.icebergStuff().retrieveIcebergSnapshot(snapshotId, content);
    }

    private IcebergTableMetadata storeTableSnapshot(String metadataJsonLocation, NessieTableSnapshot snapshot, MultiTableUpdate multiTableUpdate) {
        IcebergTableMetadata tableMetadata = NessieModelIceberg.nessieTableSnapshotToIceberg((NessieTableSnapshot)snapshot, Optional.empty(), p -> {});
        return this.storeSnapshot(metadataJsonLocation, tableMetadata, multiTableUpdate);
    }

    private IcebergViewMetadata storeViewSnapshot(String metadataJsonLocation, NessieViewSnapshot snapshot, MultiTableUpdate multiTableUpdate) {
        IcebergViewMetadata viewMetadata = NessieModelIceberg.nessieViewSnapshotToIceberg((NessieViewSnapshot)snapshot, Optional.empty(), p -> {});
        return this.storeSnapshot(metadataJsonLocation, viewMetadata, multiTableUpdate);
    }

    private <M> M storeSnapshot(String metadataJsonLocation, M metadata, MultiTableUpdate multiTableUpdate) {
        multiTableUpdate.addStoredLocation(metadataJsonLocation);
        try (OutputStream out = this.objectIO.writeObject(StorageUri.of((String)metadataJsonLocation));){
            IcebergJson.objectMapper().writeValue(out, metadata);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to write snapshot to: " + metadataJsonLocation, ex);
        }
        return metadata;
    }

    private static Optional<IcebergSpec> optionalIcebergSpec(OptionalInt specVersion) {
        return specVersion.isPresent() ? Optional.of(IcebergSpec.forVersion((int)specVersion.getAsInt())) : Optional.empty();
    }
}

