/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.projectnessie.catalog.files.api.BackendExceptionMapper;
import org.projectnessie.catalog.service.impl.PreviousTaskException;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.nessie.tasks.api.TaskBehavior;
import org.projectnessie.nessie.tasks.api.TaskState;
import org.projectnessie.versioned.storage.common.persist.ObjType;

final class EntitySnapshotTaskBehavior
implements TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> {
    private final BackendExceptionMapper exceptionMapper;
    private final Duration retryAfterThrottled;

    EntitySnapshotTaskBehavior(BackendExceptionMapper exceptionMapper, Duration retryAfterThrottled) {
        this.exceptionMapper = exceptionMapper;
        this.retryAfterThrottled = retryAfterThrottled;
    }

    public Throwable stateAsException(EntitySnapshotObj obj) {
        throw PreviousTaskException.fromTaskState(obj.taskState());
    }

    public Instant performRunningStateUpdateAt(Clock clock, EntitySnapshotObj running) {
        return clock.instant().plus(2L, ChronoUnit.SECONDS);
    }

    public TaskState runningTaskState(Clock clock, EntitySnapshotObj running) {
        Instant now = clock.instant();
        Instant retryNotBefore = now.plus(2L, ChronoUnit.SECONDS);
        Instant lostNotBefore = now.plus(1L, ChronoUnit.MINUTES);
        return TaskState.runningState((Instant)retryNotBefore, (Instant)lostNotBefore);
    }

    public EntitySnapshotObj.Builder newObjBuilder() {
        return EntitySnapshotObj.builder();
    }

    public ObjType objType() {
        return EntitySnapshotObj.OBJ_TYPE;
    }

    private Instant retryAfter(Clock clock) {
        return clock.instant().plus(this.retryAfterThrottled);
    }

    public TaskState asErrorTaskState(Clock clock, EntitySnapshotObj base, Throwable t) {
        return this.exceptionMapper.analyze(t).map(status -> {
            if (status.statusCode().isRetryable()) {
                return TaskState.retryableErrorState((Instant)this.retryAfter(clock), (String)t.toString(), (String)status.statusCode().name());
            }
            return TaskState.failureState((String)t.toString(), (String)status.statusCode().name());
        }).orElseGet(() -> TaskState.failureState((String)t.toString(), null));
    }
}

