/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.immutables.value.Value;
import org.projectnessie.catalog.files.api.ObjectIO;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskBehavior;
import org.projectnessie.catalog.service.impl.ImmutableEntitySnapshotTaskRequest;
import org.projectnessie.catalog.service.impl.ImportSnapshotWorker;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.immutables.NessieImmutable;
import org.projectnessie.nessie.tasks.api.TaskBehavior;
import org.projectnessie.nessie.tasks.api.TaskRequest;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;

@NessieImmutable
public interface EntitySnapshotTaskRequest
extends TaskRequest<EntitySnapshotObj, EntitySnapshotObj.Builder> {
    @Value.NonAttribute
    default public ObjType objType() {
        return EntitySnapshotObj.OBJ_TYPE;
    }

    public TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior();

    public ObjId objId();

    @Nullable
    public Content content();

    @Nullable
    @Value.Auxiliary
    public NessieEntitySnapshot<?> snapshot();

    @Value.Auxiliary
    public Persist persist();

    @Value.Auxiliary
    public ObjectIO objectIO();

    @Value.Auxiliary
    public Executor executor();

    @Value.NonAttribute
    default public CompletionStage<EntitySnapshotObj.Builder> submitExecution() {
        return CompletableFuture.supplyAsync(new ImportSnapshotWorker(this)::importSnapshot, this.executor());
    }

    default public EntitySnapshotObj.Builder applyRequestToObjBuilder(EntitySnapshotObj.Builder builder) {
        return builder.content(this.content());
    }

    public static EntitySnapshotTaskRequest entitySnapshotTaskRequest(ObjId objId, Content content, NessieEntitySnapshot<?> snapshot, EntitySnapshotTaskBehavior behavior, Persist persist, ObjectIO objectIO, Executor executor) {
        return ImmutableEntitySnapshotTaskRequest.of(behavior, objId, content, snapshot, persist, objectIO, executor);
    }
}

