/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import org.projectnessie.catalog.files.api.BackendErrorCode;
import org.projectnessie.nessie.tasks.api.TaskState;

public class PreviousTaskException
extends RuntimeException {
    private final BackendErrorCode errorCode;

    private PreviousTaskException(BackendErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public BackendErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static PreviousTaskException fromTaskState(TaskState state) {
        if (state == null) {
            return new PreviousTaskException(BackendErrorCode.UNKNOWN, "[unknown]");
        }
        if (state.errorCode() == null) {
            return new PreviousTaskException(BackendErrorCode.UNKNOWN, state.message());
        }
        try {
            BackendErrorCode errorCode = BackendErrorCode.valueOf((String)state.errorCode());
            return new PreviousTaskException(errorCode, state.message());
        }
        catch (IllegalArgumentException e) {
            return new PreviousTaskException(BackendErrorCode.UNKNOWN, state.message());
        }
    }
}

