/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import com.google.common.annotations.VisibleForTesting;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.projectnessie.catalog.service.api.SignerKeysService;
import org.projectnessie.catalog.service.objtypes.ImmutableSignerKeysObj;
import org.projectnessie.catalog.service.objtypes.SignerKey;
import org.projectnessie.catalog.service.objtypes.SignerKeysObj;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.Persist;

@RequestScoped
public class SignerKeysServiceImpl
implements SignerKeysService {
    public static final long SPIN_LOOP_MIN_SLEEP_MILLIS = 20L;
    public static final long SPIN_LOOP_MAX_SLEEP_MILLIS = 200L;
    public static final Duration NEW_KEY_ROTATE_AFTER = Duration.of(3L, ChronoUnit.DAYS);
    public static final Duration NEW_KEY_EXPIRE_AFTER = Duration.of(5L, ChronoUnit.DAYS);
    @Inject
    Persist persist;
    @VisibleForTesting
    Clock clock = Clock.systemUTC();

    private SignerKeysObj loadOrCreate() {
        SignerKeysObj signerKeys;
        while (true) {
            try {
                signerKeys = (SignerKeysObj)this.persist.fetchTypedObj(SignerKeysObj.OBJ_ID, SignerKeysObj.OBJ_TYPE, SignerKeysObj.class);
            }
            catch (ObjNotFoundException notFound) {
                signerKeys = this.addNewKey(null);
                try {
                    if (!this.storeInitial(signerKeys)) continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        return signerKeys;
    }

    private SignerKeysObj addNewKey(SignerKeysObj current) {
        Instant now = this.clock.instant();
        Instant rotation = now.plus(NEW_KEY_ROTATE_AFTER);
        Instant expires = now.plus(NEW_KEY_EXPIRE_AFTER);
        byte[] secretBytes = new byte[32];
        new SecureRandom().nextBytes(secretBytes);
        ImmutableSignerKeysObj.Builder keys = ImmutableSignerKeysObj.builder();
        if (current != null) {
            keys.from(current);
        }
        keys.versionToken(UUID.randomUUID().toString()).signerKeys(List.of());
        if (current != null) {
            for (SignerKey signerKey : current.signerKeys()) {
                if (signerKey.expirationTime().compareTo(now) <= 0) continue;
                keys.addSignerKey(signerKey);
            }
        }
        return keys.addSignerKey((SignerKey)SignerKey.builder().name(UUID.randomUUID().toString()).secretKey(secretBytes).creationTime(now).rotationTime(rotation).expirationTime(expires).build()).build();
    }

    public SignerKey getSignerKey(String signerKey) {
        SignerKeysObj keys = this.loadOrCreate();
        return keys.getSignerKey(signerKey);
    }

    public SignerKey currentSignerKey() {
        SignerKeysObj keys;
        SignerKey current;
        Instant now = this.clock.instant();
        while ((current = (SignerKey)(keys = this.loadOrCreate()).signerKeys().get(keys.signerKeys().size() - 1)).rotationTime().compareTo(now) <= 0) {
            SignerKeysObj updated = this.addNewKey(keys);
            try {
                if (this.updateKeys(keys, updated)) continue;
                SignerKeysServiceImpl.persistSpinLoop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return current;
    }

    @VisibleForTesting
    boolean storeInitial(SignerKeysObj signerKeys) throws ObjTooLargeException {
        return this.persist.storeObj((Obj)signerKeys);
    }

    @VisibleForTesting
    boolean updateKeys(SignerKeysObj keys, SignerKeysObj updated) throws ObjTooLargeException {
        return this.persist.updateConditional((UpdateableObj)keys, (UpdateableObj)updated);
    }

    private static void persistSpinLoop() throws InterruptedException {
        Thread.sleep(ThreadLocalRandom.current().nextLong(20L, 200L));
    }
}

