/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongSupplier;
import java.util.zip.GZIPInputStream;
import org.projectnessie.catalog.formats.iceberg.manifest.IcebergFileFormat;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergJson;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergTableMetadata;
import org.projectnessie.catalog.formats.iceberg.meta.IcebergViewMetadata;
import org.projectnessie.catalog.formats.iceberg.nessie.NessieModelIceberg;
import org.projectnessie.catalog.model.NessieEntity;
import org.projectnessie.catalog.model.NessieTable;
import org.projectnessie.catalog.model.NessieView;
import org.projectnessie.catalog.model.id.NessieId;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.catalog.model.snapshot.NessieTableSnapshot;
import org.projectnessie.catalog.model.snapshot.NessieViewSnapshot;
import org.projectnessie.catalog.model.snapshot.TableFormat;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskRequest;
import org.projectnessie.catalog.service.impl.Util;
import org.projectnessie.catalog.service.objtypes.EntityObj;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.nessie.tasks.api.TaskState;
import org.projectnessie.storage.uri.StorageUri;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImportSnapshotWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportSnapshotWorker.class);
    private final EntitySnapshotTaskRequest taskRequest;

    ImportSnapshotWorker(EntitySnapshotTaskRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    EntitySnapshotObj.Builder importSnapshot() {
        Content content = this.taskRequest.content();
        if (content instanceof IcebergTable) {
            return this.importIcebergTable((IcebergTable)content, (NessieTableSnapshot)this.taskRequest.snapshot());
        }
        if (content instanceof IcebergView) {
            return this.importIcebergView((IcebergView)content, (NessieViewSnapshot)this.taskRequest.snapshot());
        }
        throw new UnsupportedOperationException("Unsupported Nessie content type " + String.valueOf(content.getType()));
    }

    private EntitySnapshotObj.Builder importIcebergTable(IcebergTable content, NessieTableSnapshot snapshot) {
        NessieId snapshotId = Util.objIdToNessieId(this.taskRequest.objId());
        LOGGER.debug("{} Iceberg table metadata from object store for snapshot ID {} from {}", new Object[]{snapshot == null ? "Fetching" : "Storing", this.taskRequest.objId(), content.getMetadataLocation()});
        ObjId entityObjId = EntityObj.entityObjIdForContent((Content)content);
        if (snapshot == null) {
            NessieTable table;
            IcebergTableMetadata tableMetadata;
            StorageUri metadataLocation = StorageUri.of((String)content.getMetadataLocation());
            try {
                tableMetadata = this.icebergMetadata(metadataLocation, IcebergTableMetadata.class);
                table = this.entityObjForContent(content, tableMetadata, entityObjId);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read table metadata from " + content.getMetadataLocation(), e);
            }
            snapshot = NessieModelIceberg.icebergTableSnapshotToNessie((NessieId)snapshotId, null, (NessieTable)table, (IcebergTableMetadata)tableMetadata, snap -> {
                if (snap.manifestList() != null) {
                    return snap.manifestList();
                }
                if (snap.manifests() == null || snap.manifests().isEmpty()) {
                    return null;
                }
                String listFile = String.format("snap-%d-%d-%s%s", snap.snapshotId(), ThreadLocalRandom.current().nextLong(1000000L, Long.MAX_VALUE), UUID.randomUUID(), IcebergFileFormat.AVRO.fileExtension());
                return metadataLocation.resolve(listFile).toString();
            });
        }
        return EntitySnapshotObj.builder().id(Util.nessieIdToObjId(snapshotId)).entity(entityObjId).snapshot((NessieEntitySnapshot)snapshot).content((Content)content).taskState(TaskState.successState());
    }

    private EntitySnapshotObj.Builder importIcebergView(IcebergView content, NessieViewSnapshot snapshot) {
        NessieId snapshotId = Util.objIdToNessieId(this.taskRequest.objId());
        LOGGER.debug("{} Iceberg view metadata from object store for snapshot ID {} from {}", new Object[]{snapshot == null ? "Fetching" : "Storing", this.taskRequest.objId(), content.getMetadataLocation()});
        ObjId entityObjId = EntityObj.entityObjIdForContent((Content)content);
        if (snapshot == null) {
            NessieView view;
            IcebergViewMetadata viewMetadata;
            StorageUri metadataLocation = StorageUri.of((String)content.getMetadataLocation());
            try {
                viewMetadata = this.icebergMetadata(metadataLocation, IcebergViewMetadata.class);
                view = this.entityObjForContent(content, viewMetadata, entityObjId, () -> viewMetadata.versions().stream().filter(v -> v.versionId() == viewMetadata.currentVersionId()).findFirst().orElseThrow(() -> new IllegalStateException("Iceberg view has no version element with the id for the current-version-ID")).timestampMs());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read view metadata from " + content.getMetadataLocation(), e);
            }
            snapshot = NessieModelIceberg.icebergViewSnapshotToNessie((NessieId)snapshotId, null, (NessieView)view, (IcebergViewMetadata)viewMetadata);
        }
        return EntitySnapshotObj.builder().id(Util.nessieIdToObjId(snapshotId)).entity(entityObjId).snapshot((NessieEntitySnapshot)snapshot).content((Content)content).taskState(TaskState.successState());
    }

    private NessieTable entityObjForContent(IcebergTable content, IcebergTableMetadata tableMetadata, ObjId entityObjId) throws ObjTooLargeException {
        NessieTable table;
        block2: {
            try {
                EntityObj entity = (EntityObj)this.taskRequest.persist().fetchObj(entityObjId);
                table = (NessieTable)entity.entity();
            }
            catch (ObjNotFoundException nf) {
                NessieTable.Builder tableBuilder = (NessieTable.Builder)((NessieTable.Builder)((NessieTable.Builder)((NessieTable.Builder)NessieTable.builder().createdTimestamp(Instant.ofEpochMilli(tableMetadata.lastUpdatedMs()))).tableFormat(TableFormat.ICEBERG)).icebergUuid(tableMetadata.tableUuid())).nessieContentId(content.getId());
                table = tableBuilder.build();
                if (!this.taskRequest.persist().storeObj((Obj)ImportSnapshotWorker.buildEntityObj(entityObjId, (NessieEntity)table))) break block2;
                LOGGER.debug("Persisted new entity object for content ID {}", (Object)content.getId());
            }
        }
        return table;
    }

    private NessieView entityObjForContent(IcebergView content, IcebergViewMetadata viewMetadata, ObjId entityObjId, LongSupplier lastUpdatedMs) throws ObjTooLargeException {
        NessieView view;
        block2: {
            try {
                EntityObj entity = (EntityObj)this.taskRequest.persist().fetchObj(entityObjId);
                view = (NessieView)entity.entity();
            }
            catch (ObjNotFoundException nf) {
                NessieView.Builder viewBuilder = (NessieView.Builder)((NessieView.Builder)((NessieView.Builder)((NessieView.Builder)NessieView.builder().createdTimestamp(Instant.ofEpochMilli(lastUpdatedMs.getAsLong()))).tableFormat(TableFormat.ICEBERG)).icebergUuid(viewMetadata.viewUuid())).nessieContentId(content.getId());
                view = viewBuilder.build();
                if (!this.taskRequest.persist().storeObj((Obj)ImportSnapshotWorker.buildEntityObj(entityObjId, (NessieEntity)view))) break block2;
                LOGGER.debug("Persisted new entity object for content ID {}", (Object)content.getId());
            }
        }
        return view;
    }

    private static EntityObj buildEntityObj(ObjId entityObjId, NessieEntity entity) {
        return EntityObj.builder().id(entityObjId).entity(entity).versionToken(ObjId.randomObjId().toString()).build();
    }

    private <T> T icebergMetadata(StorageUri metadataLocation, Class<? extends T> metadataType) throws IOException {
        InputStream input = this.metadataInputStream(metadataLocation);
        return (T)IcebergJson.objectMapper().readValue(input, metadataType);
    }

    private InputStream metadataInputStream(StorageUri metadataLocation) throws IOException {
        InputStream input = this.taskRequest.objectIO().readObject(metadataLocation);
        if (metadataLocation.requiredPath().endsWith(".gz") || metadataLocation.requiredPath().endsWith(".gz.metadata.json")) {
            return new GZIPInputStream(input);
        }
        return input;
    }
}

