/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api.ns;

import java.util.Map;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceResult;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseCreateNamespaceBuilder;
import org.projectnessie.error.ContentKeyErrorDetails;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;

public final class ClientSideCreateNamespace
extends BaseCreateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideCreateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public Namespace create() throws NessieReferenceNotFoundException, NessieNamespaceAlreadyExistsException {
        return this.createWithResponse().getNamespace();
    }

    @Override
    public CreateNamespaceResult createWithResponse() throws NessieReferenceNotFoundException, NessieNamespaceAlreadyExistsException {
        GetMultipleContentsResponse contentsResponse;
        if (this.namespace.isEmpty()) {
            throw new IllegalArgumentException("Creating empty namespaces is not supported");
        }
        ImmutableNamespace content = Namespace.builder().from(this.namespace).properties(this.properties).build();
        ContentKey key = this.namespace.toContentKey();
        try {
            contentsResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).key(key).getWithResponse();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        Map contentMap = contentsResponse.toContentsMap();
        Content existing = (Content)contentMap.get(key);
        if (existing != null) {
            if (existing instanceof Namespace) {
                throw new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)key), String.format("Namespace '%s' already exists", key.toCanonicalString()));
            }
            throw new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)key), String.format("Another content object with name '%s' already exists", key.toCanonicalString()));
        }
        try {
            Branch branch = (Branch)contentsResponse.getEffectiveReference();
            CommitMeta meta = this.commitMeta;
            if (meta == null) {
                meta = CommitMeta.fromMessage((String)("create namespace " + String.valueOf(key)));
            } else if (meta.getMessage().isEmpty()) {
                meta = CommitMeta.builder().from(meta).message("update namespace " + String.valueOf(key)).build();
            }
            CommitResponse committed = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().commitMeta(meta).branch(branch)).operation((Operation)Operation.Put.of((ContentKey)key, (Content)content)).commitWithResponse();
            Namespace created = content.withId((String)committed.toAddedContentsMap().get(key));
            return CreateNamespaceResult.of(created, committed.getTargetBranch());
        }
        catch (NessieConflictException | NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }
}

