/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.projectnessie.client.auth.NessieAuthentication;

public interface NessieAuthenticationProvider {
    public static NessieAuthentication fromConfig(Function<String, String> configuration) {
        String authType = configuration.apply("nessie.authentication.type");
        if (authType == null) {
            authType = configuration.apply("nessie.auth-type");
        }
        if (authType != null) {
            NessieAuthenticationProvider ap2;
            for (NessieAuthenticationProvider ap2 : ServiceLoader.load(NessieAuthenticationProvider.class)) {
                if (!ap2.getAuthTypeValue().equalsIgnoreCase(authType)) continue;
                return ap2.build(configuration);
            }
            Object reflectionClassName = NessieAuthentication.class.getName();
            reflectionClassName = ((String)reflectionClassName).substring(0, ((String)reflectionClassName).lastIndexOf(46) + 1) + authType.substring(0, 1).toUpperCase(Locale.ROOT) + authType.substring(1).toLowerCase(Locale.ROOT) + "AuthenticationProvider";
            try {
                Class<?> provider = Class.forName((String)reflectionClassName);
                ap2 = (NessieAuthenticationProvider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("No authentication provider for '%s' found using class name '%s'.", authType, reflectionClassName));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Could not initialize '%s': %s", reflectionClassName, e), e);
            }
            return ap2.build(configuration);
        }
        return null;
    }

    public String getAuthTypeValue();

    public NessieAuthentication build(Function<String, String> var1);
}

