/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.ImmutableTokenExchangeRequest;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@JsonSerialize(as=ImmutableTokenExchangeRequest.class)
@JsonDeserialize(as=ImmutableTokenExchangeRequest.class)
@JsonTypeName(value="urn:ietf:params:oauth:grant-type:token-exchange")
@Value.Immutable
interface TokenExchangeRequest
extends TokenRequestBase,
PublicClientRequest {
    @Override
    @Value.Derived
    default public GrantType getGrantType() {
        return GrantType.TOKEN_EXCHANGE;
    }

    @Nullable
    public URI getResource();

    @Nullable
    public String getAudience();

    @Nullable
    @JsonProperty(value="requested_token_type")
    public URI getRequestedTokenType();

    @JsonProperty(value="subject_token")
    public String getSubjectToken();

    @JsonProperty(value="subject_token_type")
    public URI getSubjectTokenType();

    @Nullable
    @JsonProperty(value="actor_token")
    public String getActorToken();

    @Nullable
    @JsonProperty(value="actor_token_type")
    public URI getActorTokenType();

    public static Builder builder() {
        return ImmutableTokenExchangeRequest.builder();
    }

    public static interface Builder
    extends TokenRequestBase.Builder<TokenExchangeRequest>,
    PublicClientRequest.Builder<TokenExchangeRequest> {
        @CanIgnoreReturnValue
        public Builder resource(URI var1);

        @CanIgnoreReturnValue
        public Builder audience(String var1);

        @CanIgnoreReturnValue
        public Builder requestedTokenType(URI var1);

        @CanIgnoreReturnValue
        public Builder subjectToken(String var1);

        @CanIgnoreReturnValue
        public Builder subjectTokenType(URI var1);

        @CanIgnoreReturnValue
        public Builder actorToken(String var1);

        @CanIgnoreReturnValue
        public Builder actorTokenType(URI var1);
    }
}

