/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import java.util.Map;
import java.util.stream.Collectors;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.builder.BaseGetContentBuilder;
import org.projectnessie.client.rest.v1.NessieApiClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;

final class HttpGetContent
extends BaseGetContentBuilder {
    private final NessieApiClient client;

    HttpGetContent(NessieApiClient client) {
        this.client = client;
    }

    @Override
    public Map<ContentKey, Content> get() throws NessieNotFoundException {
        GetMultipleContentsResponse resp = this.client.getContentApi().getMultipleContents(this.refName, this.hashOnRef, (GetMultipleContentsRequest)this.request.build());
        return resp.getContents().stream().collect(Collectors.toMap(GetMultipleContentsResponse.ContentWithKey::getKey, GetMultipleContentsResponse.ContentWithKey::getContent));
    }

    @Override
    public ContentResponse getSingle(ContentKey key) {
        throw new UnsupportedOperationException("Get single content is not available in API v1");
    }

    @Override
    public GetMultipleContentsResponse getWithResponse() {
        throw new UnsupportedOperationException("Extended contents response data is not available in API v1");
    }

    @Override
    public GetContentBuilder forWrite(boolean forWrite) {
        if (forWrite) {
            throw new UnsupportedOperationException("forWrite is not available in API v1");
        }
        return super.forWrite(forWrite);
    }
}

