/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.builder.BaseGetEntriesBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.rest.v2.HttpApiV2;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.Reference;

final class HttpGetEntries
extends BaseGetEntriesBuilder<EntriesParams> {
    private final HttpClient client;
    private final HttpApiV2 api;

    HttpGetEntries(HttpClient client, HttpApiV2 api) {
        super(EntriesParams::forNextPage);
        this.client = client;
        this.api = api;
    }

    @Override
    @Deprecated
    public GetEntriesBuilder namespaceDepth(Integer namespaceDepth) {
        throw new UnsupportedOperationException("namespaceDepth is not supported for Nessie API v2");
    }

    @Override
    protected EntriesParams params() {
        return EntriesParams.builder().filter(this.filter).minKey(this.minKey).maxKey(this.maxKey).prefixKey(this.prefixKey).requestedKeys((Iterable)this.keys).maxRecords(this.maxRecords).withContent(Boolean.valueOf(this.withContent)).build();
    }

    @Override
    protected EntriesResponse get(EntriesParams p) throws NessieNotFoundException {
        HttpRequest req = this.client.newRequest().path("trees/{ref}/entries").resolveTemplate("ref", Reference.toPathString((String)this.refName, (String)this.hashOnRef)).queryParam("filter", p.filter()).queryParam("content", p.withContent() ? "true" : null).queryParam("page-token", p.pageToken()).queryParam("max-records", p.maxRecords());
        p.getRequestedKeys().forEach(k -> req.queryParam("key", this.api.toPathString((ContentKey)k)));
        ContentKey k2 = p.minKey();
        if (k2 != null) {
            req.queryParam("min-key", this.api.toPathString(k2));
        }
        if ((k2 = p.maxKey()) != null) {
            req.queryParam("max-key", this.api.toPathString(k2));
        }
        if ((k2 = p.prefixKey()) != null) {
            req.queryParam("prefix-key", this.api.toPathString(k2));
        }
        return req.unwrap(NessieNotFoundException.class).get().readEntity(EntriesResponse.class);
    }
}

