/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import org.projectnessie.api.v1.params.ImmutableMerge;
import org.projectnessie.api.v1.params.Merge;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.builder.BaseMergeReferenceBuilder;
import org.projectnessie.client.rest.v1.NessieApiClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.MergeResponse;

final class HttpMergeReference
extends BaseMergeReferenceBuilder {
    private final NessieApiClient client;

    HttpMergeReference(NessieApiClient client) {
        this.client = client;
    }

    @Override
    public MergeReferenceBuilder message(String message) {
        throw new UnsupportedOperationException("Merge message overrides are not supported in API v1.");
    }

    @Override
    public MergeReferenceBuilder commitMeta(CommitMeta commitMeta) {
        throw new UnsupportedOperationException("Merge commit-meta overrides are not supported in API v1.");
    }

    @Override
    public MergeResponse merge() throws NessieNotFoundException, NessieConflictException {
        ImmutableMerge.Builder merge = ImmutableMerge.builder().fromHash(this.fromHash).fromRefName(this.fromRefName).isDryRun(this.dryRun).isReturnConflictAsResult(this.returnConflictAsResult).isFetchAdditionalInfo(this.fetchAdditionalInfo).keepIndividualCommits(this.keepIndividualCommits);
        if (this.defaultMergeMode != null) {
            merge.defaultKeyMergeMode(this.defaultMergeMode);
        }
        if (this.mergeModes != null) {
            merge.keyMergeModes(this.mergeModes.values());
        }
        return this.client.getTreeApi().mergeRefIntoBranch(this.branchName, this.hash, (Merge)merge.build());
    }
}

