/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.UpdateNamespaceResult;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateNamespaceResult", generator="Immutables")
@Immutable
public final class ImmutableUpdateNamespaceResult
implements UpdateNamespaceResult {
    private final Namespace namespace;
    private final Namespace namespaceBeforeUpdate;
    private final Branch effectiveBranch;

    private ImmutableUpdateNamespaceResult(Namespace namespace, Namespace namespaceBeforeUpdate, Branch effectiveBranch) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.namespaceBeforeUpdate = Objects.requireNonNull(namespaceBeforeUpdate, "namespaceBeforeUpdate");
        this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
    }

    private ImmutableUpdateNamespaceResult(ImmutableUpdateNamespaceResult original, Namespace namespace, Namespace namespaceBeforeUpdate, Branch effectiveBranch) {
        this.namespace = namespace;
        this.namespaceBeforeUpdate = namespaceBeforeUpdate;
        this.effectiveBranch = effectiveBranch;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Namespace getNamespaceBeforeUpdate() {
        return this.namespaceBeforeUpdate;
    }

    @Override
    public Branch getEffectiveBranch() {
        return this.effectiveBranch;
    }

    public final ImmutableUpdateNamespaceResult withNamespace(Namespace value) {
        if (this.namespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespace");
        return new ImmutableUpdateNamespaceResult(this, newValue, this.namespaceBeforeUpdate, this.effectiveBranch);
    }

    public final ImmutableUpdateNamespaceResult withNamespaceBeforeUpdate(Namespace value) {
        if (this.namespaceBeforeUpdate == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespaceBeforeUpdate");
        return new ImmutableUpdateNamespaceResult(this, this.namespace, newValue, this.effectiveBranch);
    }

    public final ImmutableUpdateNamespaceResult withEffectiveBranch(Branch value) {
        if (this.effectiveBranch == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "effectiveBranch");
        return new ImmutableUpdateNamespaceResult(this, this.namespace, this.namespaceBeforeUpdate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNamespaceResult && this.equalTo(0, (ImmutableUpdateNamespaceResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNamespaceResult another) {
        return this.namespace.equals(another.namespace) && this.namespaceBeforeUpdate.equals(another.namespaceBeforeUpdate) && this.effectiveBranch.equals(another.effectiveBranch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + this.namespaceBeforeUpdate.hashCode();
        h += (h << 5) + this.effectiveBranch.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateNamespaceResult{namespace=" + this.namespace + ", namespaceBeforeUpdate=" + this.namespaceBeforeUpdate + ", effectiveBranch=" + this.effectiveBranch + "}";
    }

    public static ImmutableUpdateNamespaceResult of(Namespace namespace, Namespace namespaceBeforeUpdate, Branch effectiveBranch) {
        return new ImmutableUpdateNamespaceResult(namespace, namespaceBeforeUpdate, effectiveBranch);
    }

    public static ImmutableUpdateNamespaceResult copyOf(UpdateNamespaceResult instance) {
        if (instance instanceof ImmutableUpdateNamespaceResult) {
            return (ImmutableUpdateNamespaceResult)instance;
        }
        return ImmutableUpdateNamespaceResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateNamespaceResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long INIT_BIT_NAMESPACE_BEFORE_UPDATE = 2L;
        private static final long INIT_BIT_EFFECTIVE_BRANCH = 4L;
        private long initBits = 7L;
        @Nullable
        private Namespace namespace;
        @Nullable
        private Namespace namespaceBeforeUpdate;
        @Nullable
        private Branch effectiveBranch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateNamespaceResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namespace(instance.getNamespace());
            this.namespaceBeforeUpdate(instance.getNamespaceBeforeUpdate());
            this.effectiveBranch(instance.getEffectiveBranch());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespaceBeforeUpdate(Namespace namespaceBeforeUpdate) {
            this.namespaceBeforeUpdate = Objects.requireNonNull(namespaceBeforeUpdate, "namespaceBeforeUpdate");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder effectiveBranch(Branch effectiveBranch) {
            this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateNamespaceResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNamespaceResult(null, this.namespace, this.namespaceBeforeUpdate, this.effectiveBranch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("namespaceBeforeUpdate");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("effectiveBranch");
            }
            return "Cannot build UpdateNamespaceResult, some of required attributes are not set " + attributes;
        }
    }
}

