/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import javax.validation.constraints.NotNull;
import org.projectnessie.api.v1.http.HttpNamespaceApi;
import org.projectnessie.api.v1.params.MultipleNamespacesParams;
import org.projectnessie.api.v1.params.NamespaceParams;
import org.projectnessie.api.v1.params.NamespaceUpdate;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.Namespace;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HttpNamespaceClient
implements HttpNamespaceApi {
    private final HttpClient client;

    public HttpNamespaceClient(HttpClient client) {
        this.client = client;
    }

    public Namespace createNamespace(@NotNull NamespaceParams params, @NotNull Namespace namespace) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).put(namespace).readEntity(Namespace.class);
    }

    public void deleteNamespace(@NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieNamespaceNotEmptyException, NessieReferenceNotFoundException {
        this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).delete();
    }

    public Namespace getNamespace(@NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).get().readEntity(Namespace.class);
    }

    public GetNamespacesResponse getNamespaces(@NotNull MultipleNamespacesParams params) throws NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/{ref}").resolveTemplate("ref", params.getRefName()).queryParam("name", null != params.getNamespace() ? params.getNamespace().toPathString() : null).queryParam("hashOnRef", params.getHashOnRef()).get().readEntity(GetNamespacesResponse.class);
    }

    public void updateProperties(@NotNull NamespaceParams params, @NotNull NamespaceUpdate namespaceUpdate) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).post(namespaceUpdate);
    }
}

