/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.config;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NessieClientConfigSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieClientConfigSources.class);
    private static final NessieClientConfigSource EMPTY_CONFIG_SOURCE = new NessieClientConfigSource(){

        @Override
        @javax.annotation.Nullable
        @Nullable
        public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
            return null;
        }
    };

    private NessieClientConfigSources() {
    }

    public static NessieClientConfigSource dotEnvFileConfigSource() {
        Path dotEnvFile = NessieClientConfigSources.dotEnvFile();
        return NessieClientConfigSources.environmentFileConfigSource(dotEnvFile);
    }

    public static NessieClientConfigSource nessieClientConfigFileConfigSource() {
        Path propertiesFile = NessieClientConfigSources.nessieClientConfigFile();
        return NessieClientConfigSources.propertiesFileConfigSource(propertiesFile);
    }

    public static NessieClientConfigSource systemEnvironmentConfigSource() {
        return NessieClientConfigSources.environmentConfigSource(System.getenv());
    }

    public static NessieClientConfigSource systemPropertiesConfigSource() {
        return NessieClientConfigSources.propertiesConfigSource(System.getProperties());
    }

    public static NessieClientConfigSource environmentFileConfigSource(final Path envFile) {
        if (!Files.isRegularFile(envFile, new LinkOption[0])) {
            return EMPTY_CONFIG_SOURCE;
        }
        final Properties props = NessieClientConfigSources.loadProperties(envFile);
        return new NessieClientConfigSource(){

            @Override
            @javax.annotation.Nullable
            @Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String envName = NessieClientConfigSources.propertyNameToEnvironmentName(key);
                String v = props.getProperty(envName);
                LOGGER.debug("Config value for key {} as {} retrieved from {}", new Object[]{key, envName, envFile});
                return v;
            }
        };
    }

    public static NessieClientConfigSource environmentConfigSource(final Map<String, String> environment) {
        return new NessieClientConfigSource(){

            @Override
            @javax.annotation.Nullable
            @Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String envName = NessieClientConfigSources.propertyNameToEnvironmentName(key);
                String v = (String)environment.get(envName);
                LOGGER.debug("Config value for key {} as {} retrieved from environment", (Object)key, (Object)envName);
                return v;
            }
        };
    }

    public static NessieClientConfigSource propertiesFileConfigSource(final Path propertiesFile) {
        if (!Files.isRegularFile(propertiesFile, new LinkOption[0])) {
            return EMPTY_CONFIG_SOURCE;
        }
        final Properties props = NessieClientConfigSources.loadProperties(propertiesFile);
        return new NessieClientConfigSource(){

            @Override
            @javax.annotation.Nullable
            @Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = props.getProperty(key);
                LOGGER.debug("Config value for key {} retrieved from {}", (Object)key, (Object)propertiesFile);
                return v;
            }
        };
    }

    public static NessieClientConfigSource propertiesConfigSource(final Properties properties) {
        return new NessieClientConfigSource(){

            @Override
            @javax.annotation.Nullable
            @Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = properties.getProperty(key);
                LOGGER.debug("Config value for key {} retrieved from properties", (Object)key);
                return v;
            }
        };
    }

    public static NessieClientConfigSource mapConfigSource(final Map<String, String> properties) {
        return new NessieClientConfigSource(){

            @Override
            @javax.annotation.Nullable
            @Nullable
            public String getValue(@javax.annotation.Nonnull @Nonnull String key) {
                String v = (String)properties.get(key);
                LOGGER.debug("Config value for key {} retrieved from map", (Object)key);
                return v;
            }
        };
    }

    public static String propertyNameToEnvironmentName(String propertyName) {
        return propertyName.toUpperCase(Locale.ROOT).replace('.', '_').replace('-', '_');
    }

    public static NessieClientConfigSource defaultConfigSources() {
        return NessieClientConfigSources.systemPropertiesConfigSource().fallbackTo(NessieClientConfigSources.systemEnvironmentConfigSource()).fallbackTo(NessieClientConfigSources.nessieClientConfigFileConfigSource()).fallbackTo(NessieClientConfigSources.dotEnvFileConfigSource());
    }

    public static NessieClientConfigSource fromIcebergRestCatalogProperties(Map<String, String> catalogProperties) {
        if (!Boolean.parseBoolean(catalogProperties.get("nessie.is-nessie-catalog"))) {
            throw new IllegalArgumentException("The specified properties do not belong to an Iceberg RESTCatalog backed by a Nessie Catalog service.");
        }
        Credential credential = NessieClientConfigSources.resolveCredential(catalogProperties);
        return x -> {
            switch (x) {
                case "nessie.uri": {
                    return (String)catalogProperties.get("nessie.core-base-uri") + "v2";
                }
                case "nessie.client-api-version": {
                    return "2";
                }
                case "nessie.authentication.oauth2.auth-endpoint": {
                    return NessieClientConfigSources.resolveOAuthEndpoint(catalogProperties);
                }
                case "nessie.authentication.oauth2.client-id": {
                    return credential.clientId;
                }
                case "nessie.authentication.oauth2.client-secret": {
                    return credential.secret;
                }
                case "nessie.authentication.oauth2.client-scopes": {
                    return NessieClientConfigSources.resolveOAuthScope(catalogProperties);
                }
                case "nessie.authentication.oauth2.default-access-token-lifespan": {
                    return NessieClientConfigSources.resolveTokenLifespan(catalogProperties);
                }
            }
            String v = (String)catalogProperties.get(x);
            return v != null ? v : (String)catalogProperties.get(x.replace("nessie.", ""));
        };
    }

    static String resolveTokenLifespan(Map<String, String> catalogProperties) {
        String life = catalogProperties.getOrDefault("token-expires-in-ms", "3600000");
        return Duration.ofMillis(Long.parseLong(life)).toString();
    }

    static String resolveOAuthEndpoint(Map<String, String> catalogProperties) {
        String uri = catalogProperties.get("oauth2-server-uri");
        if (uri != null) {
            return uri;
        }
        URI baseUri = URI.create(Objects.requireNonNull(catalogProperties.get("nessie.iceberg-base-uri"), "Missing 'nessie.iceberg-base-uri' property"));
        return baseUri.resolve("v1/oauth/tokens").toString();
    }

    static String resolveOAuthScope(Map<String, String> catalogProperties) {
        String nessieScope = "catalog " + NessieClientConfigSources.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-scopes", "") + " " + NessieClientConfigSources.resolveViaEnvironment(catalogProperties, "scope", "");
        return Arrays.stream(nessieScope.split(" ")).map(String::trim).filter(s -> !s.isEmpty()).distinct().collect(Collectors.joining(" "));
    }

    static Credential resolveCredential(Map<String, String> catalogProperties) {
        String nessieClientId = NessieClientConfigSources.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-id", null);
        String nessieClientSecret = NessieClientConfigSources.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-secret", null);
        Credential credentialFromIceberg = NessieClientConfigSources.parseIcebergCredential(NessieClientConfigSources.resolveViaEnvironment(catalogProperties, "credential", null));
        return new Credential(nessieClientId != null ? nessieClientId : credentialFromIceberg.clientId, nessieClientSecret != null ? nessieClientSecret : credentialFromIceberg.secret);
    }

    static String resolveViaEnvironment(Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("env:")) {
            String env = System.getenv(value.substring("env:".length()));
            if (env == null) {
                return defaultValue;
            }
            return env;
        }
        return value;
    }

    static Credential parseIcebergCredential(String credential) {
        if (credential == null) {
            return new Credential(null, null);
        }
        int colon = credential.indexOf(58);
        if (colon == -1) {
            return new Credential(null, credential);
        }
        return new Credential(credential.substring(0, colon), credential.substring(colon + 1));
    }

    public static NessieClientConfigSource emptyConfigSource() {
        return EMPTY_CONFIG_SOURCE;
    }

    static Path dotEnvFile() {
        return Paths.get(System.getProperty("user.dir"), ".env");
    }

    static Path nessieClientConfigFile() {
        return Paths.get(System.getProperty("user.dir"), ".config", "nessie", "nessie-client.properties");
    }

    private static Properties loadProperties(Path propertiesFile) {
        Properties props = new Properties();
        try (BufferedReader input = Files.newBufferedReader(propertiesFile);){
            props.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    static final class Credential {
        final String clientId;
        final String secret;

        Credential(String clientId, String secret) {
            this.clientId = clientId;
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Credential that = (Credential)o;
            return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.secret, that.secret);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.clientId);
            result = 31 * result + Objects.hashCode(this.secret);
            return result;
        }
    }
}

