/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AuthorizationCodeTokensRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
@Immutable
final class ImmutableAuthorizationCodeTokensRequest
implements AuthorizationCodeTokensRequest {
    @Nullable
    private final String scope;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String code;
    private final String redirectUri;

    private ImmutableAuthorizationCodeTokensRequest(@Nullable String scope, @Nullable String clientId, String code, String redirectUri) {
        this.scope = scope;
        this.clientId = clientId;
        this.code = code;
        this.redirectUri = redirectUri;
        this.grantType = Objects.requireNonNull(AuthorizationCodeTokensRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @Override
    @JsonProperty(value="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public final ImmutableAuthorizationCodeTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(value, this.clientId, this.code, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokensRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, value, this.code, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokensRequest withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.clientId, newValue, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokensRequest withRedirectUri(String value) {
        String newValue = Objects.requireNonNull(value, "redirectUri");
        if (this.redirectUri.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.clientId, this.code, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationCodeTokensRequest && this.equalTo(0, (ImmutableAuthorizationCodeTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationCodeTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.code.equals(another.code) && this.redirectUri.equals(another.redirectUri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.redirectUri.hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizationCodeTokensRequest{scope=" + this.scope + ", clientId=" + this.clientId + ", grantType=" + (Object)((Object)this.grantType) + ", code=" + this.code + ", redirectUri=" + this.redirectUri + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthorizationCodeTokensRequest fromJson(Json json) {
        Builder builder = ImmutableAuthorizationCodeTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.redirectUri != null) {
            builder.redirectUri(json.redirectUri);
        }
        return builder.build();
    }

    public static ImmutableAuthorizationCodeTokensRequest copyOf(AuthorizationCodeTokensRequest instance) {
        if (instance instanceof ImmutableAuthorizationCodeTokensRequest) {
            return (ImmutableAuthorizationCodeTokensRequest)instance;
        }
        return ImmutableAuthorizationCodeTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements AuthorizationCodeTokensRequest.Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_REDIRECT_URI = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        @Nullable
        private String clientId;
        @Nullable
        private String code;
        @Nullable
        private String redirectUri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthorizationCodeTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String clientIdValue;
            String scopeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AuthorizationCodeTokensRequest) {
                instance = (AuthorizationCodeTokensRequest)object;
                this.redirectUri(instance.getRedirectUri());
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                this.code(instance.getCode());
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="redirect_uri")
        @CanIgnoreReturnValue
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableAuthorizationCodeTokensRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.clientId, this.code, this.redirectUri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("redirectUri");
            }
            return "Cannot build AuthorizationCodeTokensRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
    static final class Json
    implements AuthorizationCodeTokensRequest {
        @Nullable
        String scope;
        @Nullable
        String clientId;
        @Nullable
        String code;
        @Nullable
        String redirectUri;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="redirect_uri")
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectUri() {
            throw new UnsupportedOperationException();
        }
    }
}

