/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.ClientCredentialsTokensRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientCredentialsTokensRequest", generator="Immutables")
@Immutable
final class ImmutableClientCredentialsTokensRequest
implements ClientCredentialsTokensRequest {
    @Nullable
    private final String scope;
    private final transient GrantType grantType;

    private ImmutableClientCredentialsTokensRequest(@Nullable String scope) {
        this.scope = scope;
        this.grantType = Objects.requireNonNull(ClientCredentialsTokensRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    public final ImmutableClientCredentialsTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableClientCredentialsTokensRequest(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCredentialsTokensRequest && this.equalTo(0, (ImmutableClientCredentialsTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientCredentialsTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals((Object)another.grantType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.grantType.hashCode();
        return h;
    }

    public String toString() {
        return "ClientCredentialsTokensRequest{scope=" + this.scope + ", grantType=" + (Object)((Object)this.grantType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClientCredentialsTokensRequest fromJson(Json json) {
        Builder builder = ImmutableClientCredentialsTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        return builder.build();
    }

    public static ImmutableClientCredentialsTokensRequest copyOf(ClientCredentialsTokensRequest instance) {
        if (instance instanceof ImmutableClientCredentialsTokensRequest) {
            return (ImmutableClientCredentialsTokensRequest)instance;
        }
        return ImmutableClientCredentialsTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientCredentialsTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ClientCredentialsTokensRequest.Builder {
        @Nullable
        private String scope;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientCredentialsTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ClientCredentialsTokensRequest) {
                instance = (ClientCredentialsTokensRequest)object;
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public ImmutableClientCredentialsTokensRequest build() {
            return new ImmutableClientCredentialsTokensRequest(this.scope);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClientCredentialsTokensRequest", generator="Immutables")
    static final class Json
    implements ClientCredentialsTokensRequest {
        @Nullable
        String scope;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }
    }
}

