/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeTokensResponse;
import org.projectnessie.client.auth.oauth2.TokensResponseBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeTokensResponse", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeTokensResponse
implements DeviceCodeTokensResponse {
    private final String tokenType;
    private final String accessTokenPayload;
    @Nullable
    private final Integer accessTokenExpiresInSeconds;
    @Nullable
    private final String refreshTokenPayload;
    @Nullable
    private final Integer refreshTokenExpiresInSeconds;
    @Nullable
    private final String scope;
    private final Map<String, Object> extraParameters;

    private ImmutableDeviceCodeTokensResponse(String tokenType, String accessTokenPayload, @Nullable Integer accessTokenExpiresInSeconds, @Nullable String refreshTokenPayload, @Nullable Integer refreshTokenExpiresInSeconds, @Nullable String scope, Map<String, Object> extraParameters) {
        this.tokenType = tokenType;
        this.accessTokenPayload = accessTokenPayload;
        this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
        this.refreshTokenPayload = refreshTokenPayload;
        this.refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
        this.scope = scope;
        this.extraParameters = extraParameters;
    }

    @Override
    @JsonProperty(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="access_token")
    public String getAccessTokenPayload() {
        return this.accessTokenPayload;
    }

    @Override
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    @Nullable
    public Integer getAccessTokenExpiresInSeconds() {
        return this.accessTokenExpiresInSeconds;
    }

    @Override
    @JsonProperty(value="refresh_token")
    @Nullable
    public String getRefreshTokenPayload() {
        return this.refreshTokenPayload;
    }

    @Override
    @JsonProperty(value="refresh_expires_in")
    @Nullable
    public Integer getRefreshTokenExpiresInSeconds() {
        return this.refreshTokenExpiresInSeconds;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public final ImmutableDeviceCodeTokensResponse withTokenType(String value) {
        String newValue = Objects.requireNonNull(value, "tokenType");
        if (this.tokenType.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(newValue, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withAccessTokenPayload(String value) {
        String newValue = Objects.requireNonNull(value, "accessTokenPayload");
        if (this.accessTokenPayload.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, newValue, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withAccessTokenExpiresInSeconds(@Nullable Integer value) {
        if (Objects.equals(this.accessTokenExpiresInSeconds, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, value, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withRefreshTokenPayload(@Nullable String value) {
        if (Objects.equals(this.refreshTokenPayload, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, value, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withRefreshTokenExpiresInSeconds(@Nullable Integer value) {
        if (Objects.equals(this.refreshTokenExpiresInSeconds, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, value, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, value, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokensResponse withExtraParameters(Map<String, ? extends Object> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableDeviceCodeTokensResponse.createUnmodifiableMap(true, false, entries);
        return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeTokensResponse && this.equalTo(0, (ImmutableDeviceCodeTokensResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeviceCodeTokensResponse another) {
        return this.tokenType.equals(another.tokenType) && this.accessTokenPayload.equals(another.accessTokenPayload) && Objects.equals(this.accessTokenExpiresInSeconds, another.accessTokenExpiresInSeconds) && Objects.equals(this.refreshTokenPayload, another.refreshTokenPayload) && Objects.equals(this.refreshTokenExpiresInSeconds, another.refreshTokenExpiresInSeconds) && Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tokenType.hashCode();
        h += (h << 5) + this.accessTokenPayload.hashCode();
        h += (h << 5) + Objects.hashCode(this.accessTokenExpiresInSeconds);
        h += (h << 5) + Objects.hashCode(this.refreshTokenPayload);
        h += (h << 5) + Objects.hashCode(this.refreshTokenExpiresInSeconds);
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.extraParameters.hashCode();
        return h;
    }

    public String toString() {
        return "DeviceCodeTokensResponse{tokenType=" + this.tokenType + ", accessTokenPayload=" + this.accessTokenPayload + ", accessTokenExpiresInSeconds=" + this.accessTokenExpiresInSeconds + ", refreshTokenPayload=" + this.refreshTokenPayload + ", refreshTokenExpiresInSeconds=" + this.refreshTokenExpiresInSeconds + ", scope=" + this.scope + ", extraParameters=" + this.extraParameters + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeTokensResponse fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeTokensResponse.builder();
        if (json.tokenType != null) {
            builder.tokenType(json.tokenType);
        }
        if (json.accessTokenPayload != null) {
            builder.accessTokenPayload(json.accessTokenPayload);
        }
        if (json.accessTokenExpiresInSeconds != null) {
            builder.accessTokenExpiresInSeconds(json.accessTokenExpiresInSeconds);
        }
        if (json.refreshTokenPayload != null) {
            builder.refreshTokenPayload(json.refreshTokenPayload);
        }
        if (json.refreshTokenExpiresInSeconds != null) {
            builder.refreshTokenExpiresInSeconds(json.refreshTokenExpiresInSeconds);
        }
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.extraParameters != null) {
            builder.putAllExtraParameters(json.extraParameters);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeTokensResponse copyOf(DeviceCodeTokensResponse instance) {
        if (instance instanceof ImmutableDeviceCodeTokensResponse) {
            return (ImmutableDeviceCodeTokensResponse)instance;
        }
        return ImmutableDeviceCodeTokensResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DeviceCodeTokensResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_TYPE = 1L;
        private static final long INIT_BIT_ACCESS_TOKEN_PAYLOAD = 2L;
        private long initBits = 3L;
        @Nullable
        private String tokenType;
        @Nullable
        private String accessTokenPayload;
        @Nullable
        private Integer accessTokenExpiresInSeconds;
        @Nullable
        private String refreshTokenPayload;
        @Nullable
        private Integer refreshTokenExpiresInSeconds;
        @Nullable
        private String scope;
        private Map<String, Object> extraParameters = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeTokensResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensResponseBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Integer accessTokenExpiresInSecondsValue;
            String refreshTokenPayloadValue;
            String scopeValue;
            Integer refreshTokenExpiresInSecondsValue;
            TokensResponseBase instance;
            long bits = 0L;
            if (object instanceof DeviceCodeTokensResponse) {
                instance = (DeviceCodeTokensResponse)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    refreshTokenExpiresInSecondsValue = instance.getRefreshTokenExpiresInSeconds();
                    if (refreshTokenExpiresInSecondsValue != null) {
                        this.refreshTokenExpiresInSeconds(refreshTokenExpiresInSecondsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpiresInSecondsValue = instance.getAccessTokenExpiresInSeconds();
                    if (accessTokenExpiresInSecondsValue != null) {
                        this.accessTokenExpiresInSeconds(accessTokenExpiresInSecondsValue);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof TokensResponseBase) {
                instance = (TokensResponseBase)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    refreshTokenExpiresInSecondsValue = instance.getRefreshTokenExpiresInSeconds();
                    if (refreshTokenExpiresInSecondsValue != null) {
                        this.refreshTokenExpiresInSeconds(refreshTokenExpiresInSecondsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpiresInSecondsValue = instance.getAccessTokenExpiresInSeconds();
                    if (accessTokenExpiresInSecondsValue != null) {
                        this.accessTokenExpiresInSeconds(accessTokenExpiresInSecondsValue);
                    }
                    bits |= 0x40L;
                }
            }
        }

        @JsonProperty(value="token_type")
        @CanIgnoreReturnValue
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="access_token")
        @CanIgnoreReturnValue
        public final Builder accessTokenPayload(String accessTokenPayload) {
            this.accessTokenPayload = Objects.requireNonNull(accessTokenPayload, "accessTokenPayload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder accessTokenExpiresInSeconds(@Nullable Integer accessTokenExpiresInSeconds) {
            this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
            return this;
        }

        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final Builder refreshTokenPayload(@Nullable String refreshTokenPayload) {
            this.refreshTokenPayload = refreshTokenPayload;
            return this;
        }

        @JsonProperty(value="refresh_expires_in")
        @CanIgnoreReturnValue
        public final Builder refreshTokenExpiresInSeconds(@Nullable Integer refreshTokenExpiresInSeconds) {
            this.refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
            return this;
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameters(String key, Object value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameters(Map.Entry<String, ? extends Object> entry) {
            Object v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends Object> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        public ImmutableDeviceCodeTokensResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, ImmutableDeviceCodeTokensResponse.createUnmodifiableMap(false, false, this.extraParameters));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessTokenPayload");
            }
            return "Cannot build DeviceCodeTokensResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeviceCodeTokensResponse", generator="Immutables")
    static final class Json
    implements DeviceCodeTokensResponse {
        @Nullable
        String tokenType;
        @Nullable
        String accessTokenPayload;
        @Nullable
        Integer accessTokenExpiresInSeconds;
        @Nullable
        String refreshTokenPayload;
        @Nullable
        Integer refreshTokenExpiresInSeconds;
        @Nullable
        String scope;
        final Map<String, Object> extraParameters = new HashMap<String, Object>();

        Json() {
        }

        @JsonProperty(value="token_type")
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @JsonProperty(value="access_token")
        public void setAccessTokenPayload(String accessTokenPayload) {
            this.accessTokenPayload = accessTokenPayload;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        public void setAccessTokenExpiresInSeconds(@Nullable Integer accessTokenExpiresInSeconds) {
            this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshTokenPayload(@Nullable String refreshTokenPayload) {
            this.refreshTokenPayload = refreshTokenPayload;
        }

        @JsonProperty(value="refresh_expires_in")
        public void setRefreshTokenExpiresInSeconds(@Nullable Integer refreshTokenExpiresInSeconds) {
            this.refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, Object value) {
            this.extraParameters.put(key, value);
        }

        @Override
        public String getTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAccessTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAccessTokenExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefreshTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getRefreshTokenExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getExtraParameters() {
            throw new UnsupportedOperationException();
        }
    }
}

