/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.time.Duration;
import java.time.Instant;
import org.projectnessie.client.auth.oauth2.JwtToken;
import org.projectnessie.client.auth.oauth2.Token;

class OAuth2ClientUtils {
    OAuth2ClientUtils() {
    }

    static Duration shortestDelay(Instant now, Instant accessExpirationTime, Instant refreshExpirationTime, Duration refreshSafetyWindow, Duration minRefreshDelay) {
        Instant expirationTime = accessExpirationTime.isBefore(refreshExpirationTime) ? accessExpirationTime : refreshExpirationTime;
        Duration delay = Duration.between(now, expirationTime).minus(refreshSafetyWindow);
        if (delay.compareTo(minRefreshDelay) < 0) {
            delay = minRefreshDelay;
        }
        return delay;
    }

    static Instant tokenExpirationTime(Instant now, Token token, Duration defaultLifespan) {
        Instant expirationTime = null;
        if (token != null && (expirationTime = token.getExpirationTime()) == null) {
            try {
                JwtToken jwtToken = JwtToken.parse(token.getPayload());
                expirationTime = jwtToken.getExpirationTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (expirationTime == null) {
            expirationTime = now.plus(defaultLifespan);
        }
        return expirationTime;
    }
}

