/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.PasswordTokensRequest;
import org.projectnessie.client.auth.oauth2.PasswordTokensResponse;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.auth.oauth2.Tokens;

class PasswordFlow
extends AbstractFlow {
    PasswordFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens ignored) {
        String username = this.config.getUsername().orElseThrow(() -> new IllegalStateException("Username is required"));
        String password = this.config.getPassword().map(Secret::getString).orElseThrow(() -> new IllegalStateException("Password is required"));
        PasswordTokensRequest.Builder request = PasswordTokensRequest.builder().username(username).password(password);
        return this.invokeTokenEndpoint(request, PasswordTokensResponse.class);
    }
}

