/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

final class ApacheResponseContext
implements ResponseContext {
    private final ClassicHttpResponse response;
    private final URI uri;

    ApacheResponseContext(ClassicHttpResponse response, URI uri) {
        this.response = response;
        this.uri = uri;
    }

    @Override
    public Status getResponseCode() {
        return Status.fromCode(this.response.getCode());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.reader();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.reader();
    }

    @Override
    public boolean isJsonCompatibleResponse() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(59);
        if (i > 0) {
            contentType = contentType.substring(0, i);
        }
        return contentType.endsWith("/json") || contentType.endsWith("+json");
    }

    @Override
    public String getContentType() {
        Header header = this.response.getFirstHeader("Content-Type");
        return header != null ? header.getValue() : null;
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    private InputStream reader() throws IOException {
        return new RequestClosingInputStream(this.response);
    }

    private static final class RequestClosingInputStream
    extends FilterInputStream {
        private final ClassicHttpResponse response;

        RequestClosingInputStream(ClassicHttpResponse response) throws IOException {
            super(RequestClosingInputStream.closeOnFail(response));
            this.response = response;
        }

        private static InputStream closeOnFail(ClassicHttpResponse response) throws IOException {
            try {
                return response.getEntity().getContent();
            }
            catch (IOException e) {
                response.close();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.response.close();
            }
        }
    }
}

