/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieUnavailableException;

public class ResponseCheckFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void checkResponse(ResponseContext con) throws Exception {
        NessieServiceException exception;
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, MAPPER.reader());
        }
        Optional modelException = ErrorCode.asException((NessieError)error);
        if (modelException.isPresent()) {
            throw (Exception)modelException.get();
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                exception = new NessieInternalServerException(error);
                break;
            }
            case SERVICE_UNAVAILABLE: {
                exception = new NessieUnavailableException(error);
                break;
            }
            case UNAUTHORIZED: {
                exception = new NessieNotAuthorizedException(error);
                break;
            }
            default: {
                exception = new NessieServiceException(error);
            }
        }
        throw exception;
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        ImmutableNessieError error;
        if (inputStream == null) {
            error = ImmutableNessieError.builder().errorCode(ErrorCode.UNKNOWN).status(status.getCode()).reason(status.getReason()).message("Could not parse error object in response.").clientProcessingError("Could not parse error object in response.").build();
        } else {
            CapturingInputStream capturing = new CapturingInputStream(inputStream);
            try {
                JsonNode errorData = reader.readTree((InputStream)capturing);
                error = (NessieError)reader.treeToValue((TreeNode)errorData, NessieError.class);
            }
            catch (IOException e) {
                String cap = capturing.captured().trim();
                error = ImmutableNessieError.builder().message(cap.isEmpty() ? "got empty response body from server" : "Could not parse error object in response beginning with: " + capturing.captured()).status(status.getCode()).reason(status.getReason()).clientProcessingError(e.toString()).build();
            }
        }
        return error;
    }

    static final class CapturingInputStream
    extends FilterInputStream {
        static final int CAPTURE_LEN = 2048;
        private final byte[] capture = new byte[2048];
        private int captured;

        CapturingInputStream(InputStream delegate) {
            super(delegate);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rd = super.read(b, off, len);
            int captureRemain = this.capture.length - this.captured;
            if (rd > 0 && captureRemain > 0) {
                int copy = Math.min(rd, captureRemain);
                System.arraycopy(b, off, this.capture, this.captured, copy);
                this.captured += copy;
            }
            return rd;
        }

        @Override
        public int read() throws IOException {
            int rd = super.read();
            if (rd >= 0 && this.captured < this.capture.length) {
                this.capture[this.captured++] = (byte)rd;
            }
            return rd;
        }

        public String captured() {
            return new String(this.capture, 0, this.captured, StandardCharsets.UTF_8);
        }
    }
}

