/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import java.util.Map;
import org.projectnessie.client.builder.BaseGetContentBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.Reference;

final class HttpGetContent
extends BaseGetContentBuilder {
    private final HttpClient client;

    HttpGetContent(HttpClient client) {
        this.client = client;
    }

    @Override
    public Map<ContentKey, Content> get() throws NessieNotFoundException {
        return this.getWithResponse().toContentsMap();
    }

    @Override
    public ContentResponse getSingle(ContentKey key) throws NessieNotFoundException {
        if (!this.request.build().getRequestedKeys().isEmpty()) {
            throw new IllegalStateException("Must not use getSingle() with key() or keys(), pass the single key to getSingle()");
        }
        return this.client.newRequest().path("trees/{ref}/contents/{key}").resolveTemplate("ref", Reference.toPathString((String)this.refName, (String)this.hashOnRef)).resolveTemplate("key", key.toPathString()).unwrap(NessieNotFoundException.class).get().readEntity(ContentResponse.class);
    }

    @Override
    public GetMultipleContentsResponse getWithResponse() throws NessieNotFoundException {
        return this.client.newRequest().path("trees/{ref}/contents").resolveTemplate("ref", Reference.toPathString((String)this.refName, (String)this.hashOnRef)).unwrap(NessieNotFoundException.class).post(this.request.build()).readEntity(GetMultipleContentsResponse.class);
    }
}

