/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.projectnessie.client.api.GetRepositoryConfigBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.RepositoryConfigResponse;

final class HttpGetRepositoryConfig
implements GetRepositoryConfigBuilder {
    private final HttpClient client;
    private final Set<RepositoryConfig.Type> types = new HashSet<RepositoryConfig.Type>();

    HttpGetRepositoryConfig(HttpClient client) {
        this.client = client;
    }

    @Override
    public GetRepositoryConfigBuilder type(RepositoryConfig.Type type) {
        this.types.add(Objects.requireNonNull(type));
        return this;
    }

    @Override
    public RepositoryConfigResponse get() {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("repository config types to retrieve must be set");
        }
        HttpRequest req = this.client.newRequest().path("config/repository");
        this.types.stream().map(RepositoryConfig.Type::name).forEach(t -> req.queryParam("type", (String)t));
        return req.get().readEntity(RepositoryConfigResponse.class);
    }
}

