/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.testing.containerspec;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import org.projectnessie.nessie.testing.containerspec.ImmutableContainerSpecHelper;
import org.testcontainers.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.testcontainers.utility.DockerImageName;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class ContainerSpecHelper {
    public static Builder builder() {
        return ImmutableContainerSpecHelper.builder();
    }

    public abstract String name();

    public abstract Class<?> containerClass();

    /*
     * Enabled aggressive exception aggregation
     */
    public DockerImageName dockerImageName(String explicitImageName) {
        String explicitTag;
        if (explicitImageName != null) {
            return DockerImageName.parse((String)explicitImageName);
        }
        String dockerfile = String.format("Dockerfile-%s-version", this.name());
        URL resource = this.containerClass().getResource(dockerfile);
        Objects.requireNonNull(resource, dockerfile + " not found");
        String systemPropPrefix1 = "it.nessie.container." + this.name() + ".";
        String systemPropPrefix2 = "nessie.testing." + this.name() + ".";
        String envPrefix = this.name().toUpperCase(Locale.ROOT).replaceAll("-", "_") + "_DOCKER_";
        String explicitImage = System.getProperty(systemPropPrefix1 + "image");
        if (explicitImage == null) {
            explicitImage = System.getProperty(systemPropPrefix2 + "image");
        }
        if (explicitImage == null) {
            explicitImage = System.getenv(envPrefix + "IMAGE");
        }
        if ((explicitTag = System.getProperty(systemPropPrefix1 + "tag")) == null) {
            explicitTag = System.getProperty(systemPropPrefix2 + "tag");
        }
        if (explicitTag == null) {
            explicitTag = System.getenv(envPrefix + "TAG");
        }
        if (explicitImage != null && explicitTag != null) {
            return DockerImageName.parse((String)(explicitImage + ':' + explicitTag));
        }
        try (InputStream in = resource.openConnection().getInputStream();){
            DockerImageName dockerImageName;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String ln;
                String fullImageName = null;
                while ((ln = reader.readLine()) != null) {
                    if (!(ln = ln.trim()).startsWith("FROM ")) continue;
                    fullImageName = ln.substring(5).trim();
                    break;
                }
                if (fullImageName == null) {
                    throw new IllegalStateException("Dockerfile " + dockerfile + " does not contain a line starting with 'FROM '");
                }
                if (explicitImage != null || explicitTag != null) {
                    throw new IllegalArgumentException("Must specify either BOTH, image name AND tag via system properties or environment  or omit and leave it to the default " + fullImageName + " from " + dockerfile);
                }
                dockerImageName = DockerImageName.parse(fullImageName);
            }
            return dockerImageName;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract tag from " + resource, e);
        }
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder containerClass(Class<?> var1);

        @CanIgnoreReturnValue
        public Builder name(String var1);

        public ContainerSpecHelper build();
    }
}

