/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.events.api.EventType;
import org.projectnessie.events.spi.EventSubscriber;
import org.projectnessie.events.spi.EventSubscription;
import org.projectnessie.versioned.ResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscribers
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSubscribers.class);
    final List<EventSubscriber> subscribers;
    private final EnumSet<EventType> acceptedEventTypes;
    private final EnumSet<ResultType> acceptedResultTypes;
    private boolean started;
    private boolean closed;
    private Map<EventSubscription, EventSubscriber> subscriptions;

    public EventSubscribers(EventSubscriber ... subscribers) {
        this(Arrays.asList(subscribers));
    }

    public EventSubscribers(Collection<EventSubscriber> subscribers) {
        this.subscribers = List.copyOf(subscribers);
        this.acceptedEventTypes = Arrays.stream(EventType.values()).filter(t -> this.subscribers.stream().anyMatch(s -> s.accepts(t))).collect(Collectors.toCollection(() -> EnumSet.noneOf(EventType.class)));
        this.acceptedResultTypes = this.acceptedEventTypes.stream().flatMap(EventSubscribers::map).collect(Collectors.toCollection(() -> EnumSet.noneOf(ResultType.class)));
    }

    public synchronized void start(Function<EventSubscriber, EventSubscription> subscriptionFactory) {
        if (!this.started) {
            if (this.subscribers.isEmpty()) {
                LOGGER.debug("No subscribers to start.");
                this.subscriptions = Collections.emptyMap();
            } else {
                LOGGER.info("Starting subscribers...");
                HashMap<EventSubscription, EventSubscriber> subscriptions = new HashMap<EventSubscription, EventSubscriber>();
                for (EventSubscriber subscriber : this.subscribers) {
                    try {
                        EventSubscription subscription = subscriptionFactory.apply(subscriber);
                        subscriber.onSubscribe(subscription);
                        subscriptions.put(subscription, subscriber);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error starting subscriber", e);
                    }
                }
                this.subscriptions = Collections.unmodifiableMap(subscriptions);
                LOGGER.info("Done starting subscribers.");
            }
            this.started = true;
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            if (!this.subscribers.isEmpty()) {
                LOGGER.info("Closing subscribers...");
                ArrayList<Exception> errors = new ArrayList<Exception>();
                for (EventSubscriber subscriber : this.subscribers) {
                    try {
                        subscriber.close();
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
                if (!errors.isEmpty()) {
                    RuntimeException e = new RuntimeException("Error closing at least one subscriber");
                    errors.forEach(e::addSuppressed);
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                LOGGER.info("Done closing subscribers.");
            }
            this.closed = true;
        }
    }

    public List<EventSubscriber> getSubscribers() {
        return this.subscribers;
    }

    public Map<EventSubscription, EventSubscriber> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean hasSubscribersFor(EventType type) {
        return this.acceptedEventTypes.contains(type);
    }

    public boolean hasSubscribersFor(ResultType resultType) {
        return this.acceptedResultTypes.contains(resultType);
    }

    private static Stream<ResultType> map(EventType resultType) {
        switch (resultType) {
            case COMMIT: 
            case CONTENT_STORED: 
            case CONTENT_REMOVED: {
                return Stream.of(ResultType.COMMIT, ResultType.MERGE, ResultType.TRANSPLANT);
            }
            case MERGE: {
                return Stream.of(ResultType.MERGE);
            }
            case TRANSPLANT: {
                return Stream.of(ResultType.TRANSPLANT);
            }
            case REFERENCE_CREATED: {
                return Stream.of(ResultType.REFERENCE_CREATED);
            }
            case REFERENCE_UPDATED: {
                return Stream.of(ResultType.REFERENCE_ASSIGNED);
            }
            case REFERENCE_DELETED: {
                return Stream.of(ResultType.REFERENCE_DELETED);
            }
        }
        throw new IllegalArgumentException("Unknown result type: " + String.valueOf(resultType));
    }
}

