/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service;

import jakarta.annotation.Nullable;
import java.security.Principal;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.projectnessie.events.api.CommitMeta;
import org.projectnessie.events.api.Content;
import org.projectnessie.events.api.ContentKey;
import org.projectnessie.events.api.Event;
import org.projectnessie.events.api.EventType;
import org.projectnessie.events.api.ImmutableCommitEvent;
import org.projectnessie.events.api.ImmutableCommitMeta;
import org.projectnessie.events.api.ImmutableContentRemovedEvent;
import org.projectnessie.events.api.ImmutableContentStoredEvent;
import org.projectnessie.events.api.ImmutableMergeEvent;
import org.projectnessie.events.api.ImmutableReferenceCreatedEvent;
import org.projectnessie.events.api.ImmutableReferenceDeletedEvent;
import org.projectnessie.events.api.ImmutableReferenceUpdatedEvent;
import org.projectnessie.events.api.ImmutableTransplantEvent;
import org.projectnessie.events.service.EventConfig;
import org.projectnessie.events.service.util.ReferenceMapping;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ResultType;

public class EventFactory {
    protected final EventConfig config;

    public EventFactory(EventConfig config) {
        this.config = config;
    }

    protected Event newCommitEvent(Commit commit, BranchName targetBranch, String repositoryId, @Nullable Principal user) {
        org.projectnessie.model.CommitMeta commitMeta = commit.getCommitMeta();
        return ImmutableCommitEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map((NamedRef)targetBranch)).hashBefore(Objects.requireNonNull(commit.getParentHash()).asString()).hashAfter(commit.getHash().asString()).commitMeta((CommitMeta)ImmutableCommitMeta.builder().committer(Objects.requireNonNull(commitMeta.getCommitter())).authors((Iterable)commitMeta.getAllAuthors()).allSignedOffBy((Iterable)commitMeta.getAllSignedOffBy()).message(commitMeta.getMessage()).commitTimestamp(Objects.requireNonNull(commitMeta.getCommitTime())).authorTimestamp(Objects.requireNonNull(commitMeta.getAuthorTime())).allProperties(commitMeta.getAllProperties()).build()).build();
    }

    protected Event newMergeEvent(MergeResult<Commit> result, String repositoryId, @Nullable Principal user) {
        assert (result.getResultType() == ResultType.MERGE);
        String commonAncestorHash = Objects.requireNonNull(result.getCommonAncestor()).asString();
        return ImmutableMergeEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).sourceReference(ReferenceMapping.map(result.getSourceRef())).targetReference(ReferenceMapping.map((NamedRef)result.getTargetBranch())).hashBefore(result.getEffectiveTargetHash().asString()).hashAfter(Objects.requireNonNull(result.getResultantTargetHash()).asString()).commonAncestorHash(commonAncestorHash).build();
    }

    protected Event newTransplantEvent(MergeResult<Commit> result, String repositoryId, @Nullable Principal user) {
        assert (result.getResultType() == ResultType.TRANSPLANT);
        return ImmutableTransplantEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).sourceReference(ReferenceMapping.map(result.getSourceRef())).targetReference(ReferenceMapping.map((NamedRef)result.getTargetBranch())).hashBefore(result.getEffectiveTargetHash().asString()).hashAfter(Objects.requireNonNull(result.getResultantTargetHash()).asString()).build();
    }

    protected Event newReferenceCreatedEvent(ReferenceCreatedResult result, String repositoryId, @Nullable Principal user) {
        return ImmutableReferenceCreatedEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map(result.getNamedRef())).hashAfter(result.getHash().asString()).build();
    }

    protected Event newReferenceUpdatedEvent(ReferenceAssignedResult result, String repositoryId, @Nullable Principal user) {
        return ImmutableReferenceUpdatedEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map(result.getNamedRef())).hashBefore(result.getPreviousHash().asString()).hashAfter(result.getCurrentHash().asString()).build();
    }

    protected Event newReferenceDeletedEvent(ReferenceDeletedResult result, String repositoryId, @Nullable Principal user) {
        return ImmutableReferenceDeletedEvent.builder().id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map(result.getNamedRef())).hashBefore(result.getHash().asString()).build();
    }

    protected Event newContentStoredEvent(BranchName branch, Hash hash, Instant commitTimestamp, ContentKey contentKey, Content content, String repositoryId, @Nullable Principal user) {
        return ImmutableContentStoredEvent.builder().type(EventType.CONTENT_STORED).id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map((NamedRef)branch)).hash(hash.asString()).contentKey(contentKey).content(content).commitCreationTimestamp(commitTimestamp).build();
    }

    protected Event newContentRemovedEvent(BranchName branch, Hash hash, Instant commitTimestamp, ContentKey contentKey, String repositoryId, @Nullable Principal user) {
        return ImmutableContentRemovedEvent.builder().type(EventType.CONTENT_REMOVED).id(this.config.getIdGenerator().get()).eventCreationTimestamp(this.config.getClock().instant()).eventInitiator(EventFactory.extractName(user)).repositoryId(repositoryId).properties(this.config.getStaticProperties()).reference(ReferenceMapping.map((NamedRef)branch)).hash(hash.asString()).contentKey(contentKey).commitCreationTimestamp(commitTimestamp).build();
    }

    private static Optional<String> extractName(@Nullable Principal user) {
        return user == null || user.getName() == null || user.getName().isEmpty() ? Optional.empty() : Optional.of(user.getName());
    }
}

