/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.projectnessie.events.service.VersionStoreEvent;
import org.projectnessie.versioned.Result;

@Generated(from="VersionStoreEvent", generator="Immutables")
public final class ImmutableVersionStoreEvent
implements VersionStoreEvent {
    private final Result result;
    private final String repositoryId;
    private final Principal user;

    private ImmutableVersionStoreEvent(Result result, String repositoryId, Principal user) {
        this.result = result;
        this.repositoryId = repositoryId;
        this.user = user;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Optional<Principal> getUser() {
        return Optional.ofNullable(this.user);
    }

    public final ImmutableVersionStoreEvent withResult(Result value) {
        if (this.result == value) {
            return this;
        }
        Result newValue = Objects.requireNonNull(value, "result");
        return new ImmutableVersionStoreEvent(newValue, this.repositoryId, this.user);
    }

    public final ImmutableVersionStoreEvent withRepositoryId(String value) {
        String newValue = Objects.requireNonNull(value, "repositoryId");
        if (this.repositoryId.equals(newValue)) {
            return this;
        }
        return new ImmutableVersionStoreEvent(this.result, newValue, this.user);
    }

    public final ImmutableVersionStoreEvent withUser(Principal value) {
        Principal newValue = value;
        if (this.user == newValue) {
            return this;
        }
        return new ImmutableVersionStoreEvent(this.result, this.repositoryId, newValue);
    }

    public final ImmutableVersionStoreEvent withUser(Optional<? extends Principal> optional) {
        Principal value = optional.orElse(null);
        if (this.user == value) {
            return this;
        }
        return new ImmutableVersionStoreEvent(this.result, this.repositoryId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVersionStoreEvent && this.equalTo(0, (ImmutableVersionStoreEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableVersionStoreEvent another) {
        return this.result.equals(another.result) && this.repositoryId.equals(another.repositoryId) && Objects.equals(this.user, another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + this.repositoryId.hashCode();
        h += (h << 5) + Objects.hashCode(this.user);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("VersionStoreEvent{");
        builder.append("result=").append(this.result);
        builder.append(", ");
        builder.append("repositoryId=").append(this.repositoryId);
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        return builder.append("}").toString();
    }

    public static ImmutableVersionStoreEvent copyOf(VersionStoreEvent instance) {
        if (instance instanceof ImmutableVersionStoreEvent) {
            return (ImmutableVersionStoreEvent)instance;
        }
        return ImmutableVersionStoreEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VersionStoreEvent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RESULT = 1L;
        private static final long INIT_BIT_REPOSITORY_ID = 2L;
        private long initBits = 3L;
        private Result result;
        private String repositoryId;
        private Principal user;

        private Builder() {
        }

        public final Builder from(VersionStoreEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.result(instance.getResult());
            this.repositoryId(instance.getRepositoryId());
            Optional<Principal> userOptional = instance.getUser();
            if (userOptional.isPresent()) {
                this.user(userOptional);
            }
            return this;
        }

        public final Builder result(Result result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder user(Principal user) {
            this.user = user;
            return this;
        }

        public final Builder user(Optional<? extends Principal> user) {
            this.user = user.orElse(null);
            return this;
        }

        public ImmutableVersionStoreEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVersionStoreEvent(this.result, this.repositoryId, this.user);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("result");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repositoryId");
            }
            return "Cannot build VersionStoreEvent, some of required attributes are not set " + attributes;
        }
    }
}

