/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service.util;

import java.util.Optional;
import org.projectnessie.events.api.ImmutableReference;
import org.projectnessie.events.api.Reference;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;

public final class ReferenceMapping {
    private ReferenceMapping() {
    }

    public static Reference map(NamedRef refName) {
        return ImmutableReference.builder().type(ReferenceMapping.getReferenceType(refName)).fullName(ReferenceMapping.getFullReferenceName(refName)).simpleName(refName.getName()).build();
    }

    private static String getReferenceType(NamedRef ref) {
        if (ref instanceof BranchName) {
            return "BRANCH";
        }
        if (ref instanceof TagName) {
            return "TAG";
        }
        if (ref instanceof DetachedRef) {
            return "DETACHED";
        }
        return "UNKNOWN";
    }

    private static Optional<String> getFullReferenceName(NamedRef ref) {
        if (ref instanceof BranchName) {
            return Optional.of("refs/heads/" + ref.getName());
        }
        if (ref instanceof TagName) {
            return Optional.of("refs/tags/" + ref.getName());
        }
        return Optional.empty();
    }
}

