/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.projectnessie.events.spi.EventSystemConfiguration;
import org.projectnessie.events.spi.ImmutableEventSystemConfiguration;
import org.projectnessie.model.NessieConfiguration;

public interface EventConfig {
    default public EventSystemConfiguration getSystemConfiguration() {
        NessieConfiguration modelNessieConfig = NessieConfiguration.getBuiltInConfig();
        return ImmutableEventSystemConfiguration.builder().specVersion(modelNessieConfig.getSpecVersion()).minSupportedApiVersion(modelNessieConfig.getMinSupportedApiVersion()).maxSupportedApiVersion(modelNessieConfig.getMaxSupportedApiVersion()).build();
    }

    default public Map<String, String> getStaticProperties() {
        return Collections.emptyMap();
    }

    default public Supplier<UUID> getIdGenerator() {
        return UUID::randomUUID;
    }

    default public Clock getClock() {
        return Clock.systemUTC();
    }
}

