/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.service;

import java.security.Principal;
import java.util.function.Consumer;
import org.projectnessie.events.service.EventService;
import org.projectnessie.events.service.EventSubscribers;
import org.projectnessie.events.service.ImmutableVersionStoreEvent;
import org.projectnessie.events.service.VersionStoreEvent;
import org.projectnessie.versioned.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCollector
implements Consumer<Result> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultCollector.class);
    protected final EventSubscribers subscribers;
    protected final String repositoryId;
    protected final Principal user;
    protected final Consumer<VersionStoreEvent> destination;

    public ResultCollector(EventSubscribers subscribers, String repositoryId, Principal user, EventService destination) {
        this(subscribers, repositoryId, user, destination::onVersionStoreEvent);
    }

    public ResultCollector(EventSubscribers subscribers, String repositoryId, Principal user, Consumer<VersionStoreEvent> destination) {
        this.subscribers = subscribers;
        this.repositoryId = repositoryId;
        this.user = user;
        this.destination = destination;
    }

    @Override
    public void accept(Result result) {
        if (this.shouldProcess(result)) {
            LOGGER.debug("Processing received result: {}", (Object)result);
            ImmutableVersionStoreEvent event = ImmutableVersionStoreEvent.builder().result(result).repositoryId(this.repositoryId).user(this.user).build();
            this.forwardToEventService(event);
        } else {
            LOGGER.debug("Ignoring received result: {}", (Object)result);
        }
    }

    protected boolean shouldProcess(Result result) {
        return this.subscribers.hasSubscribersFor(result.getResultType());
    }

    protected void forwardToEventService(VersionStoreEvent event) {
        this.destination.accept(event);
    }
}

