/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.spi;

import java.time.Instant;
import java.util.function.Predicate;
import org.projectnessie.events.api.Event;

@FunctionalInterface
public interface EventFilter
extends Predicate<Event> {
    public static EventFilter all() {
        return e -> true;
    }

    public static EventFilter none() {
        return e -> false;
    }

    public static EventFilter and(EventFilter ... filters) {
        return e -> {
            for (EventFilter f : filters) {
                if (f.test(e)) continue;
                return false;
            }
            return true;
        };
    }

    public static EventFilter or(EventFilter ... filters) {
        return e -> {
            for (EventFilter f : filters) {
                if (!f.test(e)) continue;
                return true;
            }
            return false;
        };
    }

    public static EventFilter not(EventFilter filter) {
        return e -> !filter.test(e);
    }

    public static EventFilter repositoryId(String id) {
        return e -> e.getRepositoryId().equals(id);
    }

    public static EventFilter createdAfter(Instant i) {
        return e -> e.getEventCreationTimestamp().isAfter(i);
    }

    public static EventFilter createdBefore(Instant i) {
        return e -> e.getEventCreationTimestamp().isBefore(i);
    }

    public static EventFilter initiatedBy(String username) {
        return e -> e.getEventInitiator().filter(s -> s.equals(username)).isPresent();
    }

    public static EventFilter hasProperty(String key) {
        return e -> e.getProperties().containsKey(key);
    }

    public static EventFilter hasProperty(String key, String value) {
        return e -> e.getProperties().containsKey(key) && e.getProperties().get(key).equals(value);
    }
}

