/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.projectnessie.events.api.EventType;

public interface EventTypeFilter
extends Predicate<EventType> {
    public static EventTypeFilter all() {
        return t -> true;
    }

    public static EventTypeFilter none() {
        return t -> false;
    }

    public static EventTypeFilter of(EventType eventType) {
        return arg_0 -> eventType.equals(arg_0);
    }

    public static EventTypeFilter of(EventType ... eventTypes) {
        return EventTypeFilter.of(Arrays.asList(eventTypes));
    }

    public static EventTypeFilter of(Collection<EventType> eventTypes) {
        if (eventTypes.isEmpty()) {
            return EventTypeFilter.none();
        }
        if (eventTypes.size() == 1) {
            return EventTypeFilter.of(eventTypes.iterator().next());
        }
        return EnumSet.copyOf(eventTypes)::contains;
    }
}

