/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.events.spi.EventSystemConfiguration;

@Generated(from="EventSystemConfiguration", generator="Immutables")
public final class ImmutableEventSystemConfiguration
implements EventSystemConfiguration {
    private final String specVersion;
    private final int minSupportedApiVersion;
    private final int maxSupportedApiVersion;
    private final Map<String, String> additionalProperties;

    private ImmutableEventSystemConfiguration(String specVersion, int minSupportedApiVersion, int maxSupportedApiVersion, Map<String, String> additionalProperties) {
        this.specVersion = specVersion;
        this.minSupportedApiVersion = minSupportedApiVersion;
        this.maxSupportedApiVersion = maxSupportedApiVersion;
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public int getMinSupportedApiVersion() {
        return this.minSupportedApiVersion;
    }

    @Override
    public int getMaxSupportedApiVersion() {
        return this.maxSupportedApiVersion;
    }

    @Override
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final ImmutableEventSystemConfiguration withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableEventSystemConfiguration(newValue, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.additionalProperties);
    }

    public final ImmutableEventSystemConfiguration withMinSupportedApiVersion(int value) {
        if (this.minSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableEventSystemConfiguration(this.specVersion, value, this.maxSupportedApiVersion, this.additionalProperties);
    }

    public final ImmutableEventSystemConfiguration withMaxSupportedApiVersion(int value) {
        if (this.maxSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableEventSystemConfiguration(this.specVersion, this.minSupportedApiVersion, value, this.additionalProperties);
    }

    public final ImmutableEventSystemConfiguration withAdditionalProperties(Map<String, ? extends String> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableEventSystemConfiguration.createUnmodifiableMap(true, false, entries);
        return new ImmutableEventSystemConfiguration(this.specVersion, this.minSupportedApiVersion, this.maxSupportedApiVersion, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventSystemConfiguration && this.equalTo(0, (ImmutableEventSystemConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableEventSystemConfiguration another) {
        return this.specVersion.equals(another.specVersion) && this.minSupportedApiVersion == another.minSupportedApiVersion && this.maxSupportedApiVersion == another.maxSupportedApiVersion && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + this.minSupportedApiVersion;
        h += (h << 5) + this.maxSupportedApiVersion;
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return "EventSystemConfiguration{specVersion=" + this.specVersion + ", minSupportedApiVersion=" + this.minSupportedApiVersion + ", maxSupportedApiVersion=" + this.maxSupportedApiVersion + ", additionalProperties=" + this.additionalProperties + "}";
    }

    public static ImmutableEventSystemConfiguration copyOf(EventSystemConfiguration instance) {
        if (instance instanceof ImmutableEventSystemConfiguration) {
            return (ImmutableEventSystemConfiguration)instance;
        }
        return ImmutableEventSystemConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="EventSystemConfiguration", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SPEC_VERSION = 1L;
        private static final long INIT_BIT_MIN_SUPPORTED_API_VERSION = 2L;
        private static final long INIT_BIT_MAX_SUPPORTED_API_VERSION = 4L;
        private long initBits = 7L;
        private String specVersion;
        private int minSupportedApiVersion;
        private int maxSupportedApiVersion;
        private Map<String, String> additionalProperties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(EventSystemConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.specVersion(instance.getSpecVersion());
            this.minSupportedApiVersion(instance.getMinSupportedApiVersion());
            this.maxSupportedApiVersion(instance.getMaxSupportedApiVersion());
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder maxSupportedApiVersion(int maxSupportedApiVersion) {
            this.maxSupportedApiVersion = maxSupportedApiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putAdditionalProperty(String key, String value) {
            this.additionalProperties.put(Objects.requireNonNull(key, "additionalProperties key"), value == null ? Objects.requireNonNull(value, "additionalProperties value for key: " + key) : value);
            return this;
        }

        public final Builder putAdditionalProperty(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.additionalProperties.put(Objects.requireNonNull(k, "additionalProperties key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "additionalProperties value for key: " + k) : v);
            return this;
        }

        public final Builder additionalProperties(Map<String, ? extends String> entries) {
            this.additionalProperties.clear();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.additionalProperties.put(Objects.requireNonNull(k, "additionalProperties key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "additionalProperties value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableEventSystemConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventSystemConfiguration(this.specVersion, this.minSupportedApiVersion, this.maxSupportedApiVersion, ImmutableEventSystemConfiguration.createUnmodifiableMap(false, false, this.additionalProperties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("specVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minSupportedApiVersion");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxSupportedApiVersion");
            }
            return "Cannot build EventSystemConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

