/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.spi;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.immutables.value.Generated;
import org.projectnessie.events.spi.EventSubscription;
import org.projectnessie.events.spi.EventSystemConfiguration;

@Generated(from="EventSubscription", generator="Immutables")
public final class ImmutableEventSubscription
implements EventSubscription {
    private final UUID id;
    private final EventSystemConfiguration systemConfiguration;
    private volatile transient long lazyInitBitmap;
    private static final long ID_AS_TEXT_LAZY_INIT_BIT = 1L;
    private transient String idAsText;

    private ImmutableEventSubscription(UUID id, EventSystemConfiguration systemConfiguration) {
        this.id = id;
        this.systemConfiguration = systemConfiguration;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public EventSystemConfiguration getSystemConfiguration() {
        return this.systemConfiguration;
    }

    public final ImmutableEventSubscription withId(UUID value) {
        if (this.id == value) {
            return this;
        }
        UUID newValue = Objects.requireNonNull(value, "id");
        return new ImmutableEventSubscription(newValue, this.systemConfiguration);
    }

    public final ImmutableEventSubscription withSystemConfiguration(EventSystemConfiguration value) {
        if (this.systemConfiguration == value) {
            return this;
        }
        EventSystemConfiguration newValue = Objects.requireNonNull(value, "systemConfiguration");
        return new ImmutableEventSubscription(this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventSubscription && this.equalTo(0, (ImmutableEventSubscription)another);
    }

    private boolean equalTo(int synthetic, ImmutableEventSubscription another) {
        return this.id.equals(another.id) && this.systemConfiguration.equals(another.systemConfiguration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.systemConfiguration.hashCode();
        return h;
    }

    public String toString() {
        return "EventSubscription{id=" + this.id + ", systemConfiguration=" + this.systemConfiguration + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdAsText() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableEventSubscription immutableEventSubscription = this;
            synchronized (immutableEventSubscription) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.idAsText = Objects.requireNonNull(EventSubscription.super.getIdAsText(), "idAsText");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.idAsText;
    }

    public static ImmutableEventSubscription copyOf(EventSubscription instance) {
        if (instance instanceof ImmutableEventSubscription) {
            return (ImmutableEventSubscription)instance;
        }
        return ImmutableEventSubscription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EventSubscription", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SYSTEM_CONFIGURATION = 2L;
        private long initBits = 3L;
        private UUID id;
        private EventSystemConfiguration systemConfiguration;

        private Builder() {
        }

        public final Builder from(EventSubscription instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.systemConfiguration(instance.getSystemConfiguration());
            return this;
        }

        public final Builder id(UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder systemConfiguration(EventSystemConfiguration systemConfiguration) {
            this.systemConfiguration = Objects.requireNonNull(systemConfiguration, "systemConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEventSubscription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventSubscription(this.id, this.systemConfiguration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("systemConfiguration");
            }
            return "Cannot build EventSubscription, some of required attributes are not set " + attributes;
        }
    }
}

