/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.events.spi;

import org.projectnessie.events.api.CommitEvent;
import org.projectnessie.events.api.ContentRemovedEvent;
import org.projectnessie.events.api.ContentStoredEvent;
import org.projectnessie.events.api.Event;
import org.projectnessie.events.api.EventType;
import org.projectnessie.events.api.MergeEvent;
import org.projectnessie.events.api.ReferenceCreatedEvent;
import org.projectnessie.events.api.ReferenceDeletedEvent;
import org.projectnessie.events.api.ReferenceUpdatedEvent;
import org.projectnessie.events.api.TransplantEvent;
import org.projectnessie.events.spi.EventFilter;
import org.projectnessie.events.spi.EventSubscription;
import org.projectnessie.events.spi.EventTypeFilter;

public interface EventSubscriber
extends AutoCloseable {
    public void onSubscribe(EventSubscription var1);

    default public boolean isBlocking() {
        return false;
    }

    default public EventTypeFilter getEventTypeFilter() {
        return EventTypeFilter.all();
    }

    default public EventFilter getEventFilter() {
        return EventFilter.all();
    }

    default public boolean accepts(EventType eventType) {
        return this.getEventTypeFilter().test(eventType);
    }

    default public boolean accepts(Event event) {
        return this.accepts(event.getType()) && this.getEventFilter().test(event);
    }

    default public void onReferenceCreated(ReferenceCreatedEvent event) {
    }

    default public void onReferenceUpdated(ReferenceUpdatedEvent event) {
    }

    default public void onReferenceDeleted(ReferenceDeletedEvent event) {
    }

    default public void onCommit(CommitEvent event) {
    }

    default public void onMerge(MergeEvent event) {
    }

    default public void onTransplant(TransplantEvent event) {
    }

    default public void onContentStored(ContentStoredEvent event) {
    }

    default public void onContentRemoved(ContentRemovedEvent event) {
    }

    default public void onEvent(Event event) {
        switch (event.getType()) {
            case REFERENCE_CREATED: {
                this.onReferenceCreated((ReferenceCreatedEvent)event);
                break;
            }
            case REFERENCE_UPDATED: {
                this.onReferenceUpdated((ReferenceUpdatedEvent)event);
                break;
            }
            case REFERENCE_DELETED: {
                this.onReferenceDeleted((ReferenceDeletedEvent)event);
                break;
            }
            case COMMIT: {
                this.onCommit((CommitEvent)event);
                break;
            }
            case MERGE: {
                this.onMerge((MergeEvent)event);
                break;
            }
            case TRANSPLANT: {
                this.onTransplant((TransplantEvent)event);
                break;
            }
            case CONTENT_STORED: {
                this.onContentStored((ContentStoredEvent)event);
                break;
            }
            case CONTENT_REMOVED: {
                this.onContentRemoved((ContentRemovedEvent)event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + event.getType());
            }
        }
    }

    @Override
    public void close() throws Exception;
}

