/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.testing.keycloak;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class OAuthUtils {
    private OAuthUtils() {
    }

    public static String fetchToken(URI tokenEndpoint, String clientId, String clientSecret) {
        try {
            HttpURLConnection getToken = (HttpURLConnection)tokenEndpoint.toURL().openConnection();
            getToken.setRequestMethod("POST");
            getToken.setDoOutput(true);
            getToken.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8)));
            getToken.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStream out = getToken.getOutputStream();){
                out.write("grant_type=client_credentials&scope=catalog".getBytes(StandardCharsets.UTF_8));
            }
            JsonNode tokenResponse = (JsonNode)new ObjectMapper().readValue(getToken.getInputStream(), JsonNode.class);
            return tokenResponse.get("access_token").textValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

