/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.testing.keycloak;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dasniko.testcontainers.keycloak.ExtendableKeycloakContainer;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Retry;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.projectnessie.testing.keycloak.ImmutableKeycloakConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class CustomKeycloakContainer
extends ExtendableKeycloakContainer<CustomKeycloakContainer> {
    public static final String KEYCLOAK_REALM = "keycloak.realm";
    public static final String KEYCLOAK_USE_HTTPS = "keycloak.use.https";
    public static final String KEYCLOAK_DOCKER_IMAGE = "keycloak.docker.image";
    public static final String KEYCLOAK_DOCKER_TAG = "keycloak.docker.tag";
    public static final String KEYCLOAK_DOCKER_NETWORK_ID = "keycloak.docker.network.id";
    public static final String FEATURES_ENABLED = "keycloak.features.enabled";
    public static final String CLIENT_SECRET = "secret";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomKeycloakContainer.class);
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private final KeycloakConfig config;

    public static KeycloakConfig.Builder builder() {
        return ImmutableKeycloakConfig.builder();
    }

    public static ClientRepresentation createServiceClient(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(CLIENT_SECRET);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setStandardFlowEnabled(Boolean.valueOf(true));
        client.setRedirectUris(List.of("http://localhost:*"));
        client.setAttributes(Map.of("oauth2.device.authorization.grant.enabled", "true"));
        client.setEnabled(Boolean.valueOf(true));
        return client;
    }

    public static ClientRepresentation createWebAppClient(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(CLIENT_SECRET);
        client.setRedirectUris(Collections.singletonList("*"));
        client.setEnabled(Boolean.valueOf(true));
        return client;
    }

    public static UserRepresentation createUser(String username, List<String> realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setFirstName(username);
        user.setLastName(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(realmRoles);
        user.setEmail(username + "@gmail.com");
        user.setEmailVerified(Boolean.valueOf(true));
        user.setRequiredActions(Collections.emptyList());
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(username);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    private static void initArgs(Map<String, String> initArgs, String property, Consumer<String> consumer) {
        String value = initArgs.getOrDefault(property, System.getProperty(property));
        if (value != null) {
            consumer.accept(value);
        }
    }

    public CustomKeycloakContainer(KeycloakConfig config) {
        super(config.dockerImage() + ":" + config.dockerTag());
        this.config = config;
        this.withNetworkAliases(new String[]{"keycloak"});
        this.withFeaturesEnabled(config.featuresEnabled().toArray(new String[0]));
        this.withStartupAttempts(3);
        this.withEnv("KC_HOSTNAME_URL", this.getInternalRootUri().toString());
        String containerNetworkId = config.dockerNetworkId();
        if (containerNetworkId != null) {
            this.withNetwork(new ExternalNetwork(containerNetworkId));
        }
        if (config.useHttps()) {
            LOGGER.info("Enabling TLS for Keycloak");
            this.useTls();
        }
    }

    public void start() {
        LOGGER.info("Starting Keycloak...");
        super.start();
        LOGGER.info("Keycloak started, creating realm {}...", (Object)this.config.realmName());
        RealmRepresentation realm = this.createRealm();
        Retry.execute(() -> {
            try (Keycloak adminClient = this.getKeycloakAdminClient();){
                adminClient.realms().create(realm);
            }
        }, (int)5, (long)1000L);
        LOGGER.info("Finished setting up Keycloak, external realm auth url: {}", (Object)this.getExternalRealmUri());
    }

    private RealmRepresentation createRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(this.config.realmName());
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        realm.setAccessTokenLifespan(Integer.valueOf(60));
        int refreshTokenLifespanSeconds = 300;
        realm.setClientSessionIdleTimeout(Integer.valueOf(refreshTokenLifespanSeconds));
        realm.setClientSessionMaxLifespan(Integer.valueOf(refreshTokenLifespanSeconds));
        realm.setSsoSessionIdleTimeout(Integer.valueOf(refreshTokenLifespanSeconds));
        realm.setSsoSessionMaxLifespan(Integer.valueOf(refreshTokenLifespanSeconds));
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        this.config.realmConfigure().accept(realm);
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try (Keycloak adminClient = this.getKeycloakAdminClient();){
            RealmResource realm = adminClient.realm(this.config.realmName());
            realm.remove();
        }
        finally {
            super.stop();
        }
    }

    public URI getExternalRealmUri() {
        return URI.create(String.format("%s://%s:%s%srealms/%s", this.config.useHttps() ? "https" : "http", this.getHost(), this.config.useHttps() ? this.getHttpsPort() : this.getHttpPort(), CustomKeycloakContainer.ensureSlashes(this.getContextPath()), this.config.realmName()));
    }

    public URI getExternalTokenEndpointUri() {
        return URI.create(String.format("%s://%s:%s%srealms/%s/protocol/openid-connect/token", this.config.useHttps() ? "https" : "http", this.getHost(), this.config.useHttps() ? this.getHttpsPort() : this.getHttpPort(), CustomKeycloakContainer.ensureSlashes(this.getContextPath()), this.config.realmName()));
    }

    public URI getInternalRootUri() {
        return URI.create(String.format("%s://keycloak:%s", this.config.useHttps() ? "https" : "http", this.config.useHttps() ? 8443 : 8080));
    }

    public URI getInternalRealmUri() {
        return URI.create(String.format("%s%srealms/%s", this.getInternalRootUri(), CustomKeycloakContainer.ensureSlashes(this.getContextPath()), this.config.realmName()));
    }

    public String getExternalIp() {
        return ((ContainerNetwork)Objects.requireNonNull(this.getContainerInfo(), "Keycloak container object available, but container info is null. Is the Keycloak container started?").getNetworkSettings().getNetworks().values().iterator().next()).getIpAddress();
    }

    public URI getTokenIssuerUri() {
        return this.getInternalRealmUri();
    }

    private static String ensureSlashes(String s) {
        if (!((String)s).startsWith("/")) {
            s = "/" + (String)s;
        }
        if (!((String)s).endsWith("/")) {
            s = (String)s + "/";
        }
        return s;
    }

    @Value.Immutable
    public static abstract class KeycloakConfig {
        public static final String DEFAULT_IMAGE;
        public static final String DEFAULT_TAG;

        @Value.Default
        public String dockerImage() {
            return DEFAULT_IMAGE;
        }

        @Value.Default
        public String dockerTag() {
            return DEFAULT_TAG;
        }

        @Value.Default
        public String realmName() {
            return "quarkus";
        }

        @Value.Default
        public boolean useHttps() {
            return false;
        }

        @Value.Default
        public List<String> featuresEnabled() {
            return List.of("token-exchange", "preview");
        }

        @Nullable
        public abstract String dockerNetworkId();

        @Value.Default
        public Consumer<RealmRepresentation> realmConfigure() {
            return r -> {};
        }

        public CustomKeycloakContainer createContainer() {
            LOGGER.info("Using Keycloak image {}:{}", (Object)this.dockerImage(), (Object)this.dockerTag());
            return new CustomKeycloakContainer(this);
        }

        static {
            URL resource = KeycloakConfig.class.getResource("Dockerfile-keycloak-version");
            try (InputStream in = resource.openConnection().getInputStream();){
                String[] imageTag = Arrays.stream(new String(in.readAllBytes(), StandardCharsets.UTF_8).split("\n")).map(String::trim).filter(l -> l.startsWith("FROM ")).map(l -> l.substring(5).trim().split(":")).findFirst().orElseThrow();
                DEFAULT_IMAGE = imageTag[0];
                DEFAULT_TAG = imageTag[1];
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to extract tag from " + resource, e);
            }
        }

        public static interface Builder {
            @CanIgnoreReturnValue
            public Builder dockerImage(String var1);

            @CanIgnoreReturnValue
            public Builder dockerTag(String var1);

            @CanIgnoreReturnValue
            public Builder dockerNetworkId(String var1);

            @CanIgnoreReturnValue
            public Builder realmName(String var1);

            @CanIgnoreReturnValue
            public Builder useHttps(boolean var1);

            @CanIgnoreReturnValue
            public Builder addFeaturesEnabled(String var1);

            @CanIgnoreReturnValue
            public Builder addFeaturesEnabled(String ... var1);

            @CanIgnoreReturnValue
            public Builder featuresEnabled(Iterable<String> var1);

            @CanIgnoreReturnValue
            public Builder realmConfigure(Consumer<RealmRepresentation> var1);

            public KeycloakConfig build();

            default public Builder fromProperties(Map<String, String> initArgs) {
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.KEYCLOAK_REALM, this::realmName);
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.KEYCLOAK_USE_HTTPS, s -> this.useHttps(Boolean.parseBoolean(s)));
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.KEYCLOAK_DOCKER_IMAGE, this::dockerImage);
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.KEYCLOAK_DOCKER_TAG, this::dockerTag);
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.KEYCLOAK_DOCKER_NETWORK_ID, this::dockerNetworkId);
                CustomKeycloakContainer.initArgs(initArgs, CustomKeycloakContainer.FEATURES_ENABLED, s -> this.addFeaturesEnabled(s.split(",")));
                return this;
            }
        }
    }

    private static class ExternalNetwork
    implements Network {
        private final String networkId;

        public ExternalNetwork(String networkId) {
            this.networkId = networkId;
        }

        public Statement apply(Statement var1, Description var2) {
            return null;
        }

        public String getId() {
            return this.networkId;
        }

        public void close() {
        }
    }
}

