/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.testing.keycloak;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.keycloak.representations.idm.RealmRepresentation;
import org.projectnessie.testing.keycloak.CustomKeycloakContainer;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomKeycloakContainer.KeycloakConfig", generator="Immutables")
@Immutable
public final class ImmutableKeycloakConfig
extends CustomKeycloakContainer.KeycloakConfig {
    private final String dockerImage;
    private final String dockerTag;
    private final String realmName;
    private final boolean useHttps;
    private final List<String> featuresEnabled;
    @Nullable
    private final String dockerNetworkId;
    private final Consumer<RealmRepresentation> realmConfigure;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeycloakConfig(Builder builder) {
        this.dockerNetworkId = builder.dockerNetworkId;
        if (builder.dockerImage != null) {
            this.initShim.dockerImage(builder.dockerImage);
        }
        if (builder.dockerTag != null) {
            this.initShim.dockerTag(builder.dockerTag);
        }
        if (builder.realmName != null) {
            this.initShim.realmName(builder.realmName);
        }
        if (builder.useHttpsIsSet()) {
            this.initShim.useHttps(builder.useHttps);
        }
        if (builder.featuresEnabledIsSet()) {
            this.initShim.featuresEnabled(ImmutableKeycloakConfig.createUnmodifiableList(true, builder.featuresEnabled));
        }
        if (builder.realmConfigure != null) {
            this.initShim.realmConfigure(builder.realmConfigure);
        }
        this.dockerImage = this.initShim.dockerImage();
        this.dockerTag = this.initShim.dockerTag();
        this.realmName = this.initShim.realmName();
        this.useHttps = this.initShim.useHttps();
        this.featuresEnabled = this.initShim.featuresEnabled();
        this.realmConfigure = this.initShim.realmConfigure();
        this.initShim = null;
    }

    private ImmutableKeycloakConfig(String dockerImage, String dockerTag, String realmName, boolean useHttps, List<String> featuresEnabled, @Nullable String dockerNetworkId, Consumer<RealmRepresentation> realmConfigure) {
        this.dockerImage = dockerImage;
        this.dockerTag = dockerTag;
        this.realmName = realmName;
        this.useHttps = useHttps;
        this.featuresEnabled = featuresEnabled;
        this.dockerNetworkId = dockerNetworkId;
        this.realmConfigure = realmConfigure;
        this.initShim = null;
    }

    @Override
    public String dockerImage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerImage() : this.dockerImage;
    }

    @Override
    public String dockerTag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerTag() : this.dockerTag;
    }

    @Override
    public String realmName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.realmName() : this.realmName;
    }

    @Override
    public boolean useHttps() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useHttps() : this.useHttps;
    }

    @Override
    public List<String> featuresEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featuresEnabled() : this.featuresEnabled;
    }

    @Override
    @Nullable
    public String dockerNetworkId() {
        return this.dockerNetworkId;
    }

    @Override
    public Consumer<RealmRepresentation> realmConfigure() {
        InitShim shim = this.initShim;
        return shim != null ? shim.realmConfigure() : this.realmConfigure;
    }

    public final ImmutableKeycloakConfig withDockerImage(String value) {
        String newValue = Objects.requireNonNull(value, "dockerImage");
        if (this.dockerImage.equals(newValue)) {
            return this;
        }
        return new ImmutableKeycloakConfig(newValue, this.dockerTag, this.realmName, this.useHttps, this.featuresEnabled, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withDockerTag(String value) {
        String newValue = Objects.requireNonNull(value, "dockerTag");
        if (this.dockerTag.equals(newValue)) {
            return this;
        }
        return new ImmutableKeycloakConfig(this.dockerImage, newValue, this.realmName, this.useHttps, this.featuresEnabled, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withRealmName(String value) {
        String newValue = Objects.requireNonNull(value, "realmName");
        if (this.realmName.equals(newValue)) {
            return this;
        }
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, newValue, this.useHttps, this.featuresEnabled, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withUseHttps(boolean value) {
        if (this.useHttps == value) {
            return this;
        }
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, this.realmName, value, this.featuresEnabled, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withFeaturesEnabled(String ... elements) {
        List<String> newValue = ImmutableKeycloakConfig.createUnmodifiableList(false, ImmutableKeycloakConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, this.realmName, this.useHttps, newValue, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withFeaturesEnabled(Iterable<String> elements) {
        if (this.featuresEnabled == elements) {
            return this;
        }
        List<String> newValue = ImmutableKeycloakConfig.createUnmodifiableList(false, ImmutableKeycloakConfig.createSafeList(elements, true, false));
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, this.realmName, this.useHttps, newValue, this.dockerNetworkId, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withDockerNetworkId(@Nullable String value) {
        if (Objects.equals(this.dockerNetworkId, value)) {
            return this;
        }
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, this.realmName, this.useHttps, this.featuresEnabled, value, this.realmConfigure);
    }

    public final ImmutableKeycloakConfig withRealmConfigure(Consumer<RealmRepresentation> value) {
        if (this.realmConfigure == value) {
            return this;
        }
        Consumer<RealmRepresentation> newValue = Objects.requireNonNull(value, "realmConfigure");
        return new ImmutableKeycloakConfig(this.dockerImage, this.dockerTag, this.realmName, this.useHttps, this.featuresEnabled, this.dockerNetworkId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeycloakConfig && this.equalTo(0, (ImmutableKeycloakConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeycloakConfig another) {
        return this.dockerImage.equals(another.dockerImage) && this.dockerTag.equals(another.dockerTag) && this.realmName.equals(another.realmName) && this.useHttps == another.useHttps && this.featuresEnabled.equals(another.featuresEnabled) && Objects.equals(this.dockerNetworkId, another.dockerNetworkId) && this.realmConfigure.equals(another.realmConfigure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dockerImage.hashCode();
        h += (h << 5) + this.dockerTag.hashCode();
        h += (h << 5) + this.realmName.hashCode();
        h += (h << 5) + Boolean.hashCode(this.useHttps);
        h += (h << 5) + this.featuresEnabled.hashCode();
        h += (h << 5) + Objects.hashCode(this.dockerNetworkId);
        h += (h << 5) + this.realmConfigure.hashCode();
        return h;
    }

    public String toString() {
        return "KeycloakConfig{dockerImage=" + this.dockerImage + ", dockerTag=" + this.dockerTag + ", realmName=" + this.realmName + ", useHttps=" + this.useHttps + ", featuresEnabled=" + this.featuresEnabled + ", dockerNetworkId=" + this.dockerNetworkId + ", realmConfigure=" + this.realmConfigure + "}";
    }

    public static ImmutableKeycloakConfig copyOf(CustomKeycloakContainer.KeycloakConfig instance) {
        if (instance instanceof ImmutableKeycloakConfig) {
            return (ImmutableKeycloakConfig)instance;
        }
        return ImmutableKeycloakConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CustomKeycloakContainer.KeycloakConfig", generator="Immutables")
    private final class InitShim {
        private byte dockerImageBuildStage = 0;
        private String dockerImage;
        private byte dockerTagBuildStage = 0;
        private String dockerTag;
        private byte realmNameBuildStage = 0;
        private String realmName;
        private byte useHttpsBuildStage = 0;
        private boolean useHttps;
        private byte featuresEnabledBuildStage = 0;
        private List<String> featuresEnabled;
        private byte realmConfigureBuildStage = 0;
        private Consumer<RealmRepresentation> realmConfigure;

        private InitShim() {
        }

        String dockerImage() {
            if (this.dockerImageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerImageBuildStage == 0) {
                this.dockerImageBuildStage = (byte)-1;
                this.dockerImage = Objects.requireNonNull(ImmutableKeycloakConfig.super.dockerImage(), "dockerImage");
                this.dockerImageBuildStage = 1;
            }
            return this.dockerImage;
        }

        void dockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            this.dockerImageBuildStage = 1;
        }

        String dockerTag() {
            if (this.dockerTagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerTagBuildStage == 0) {
                this.dockerTagBuildStage = (byte)-1;
                this.dockerTag = Objects.requireNonNull(ImmutableKeycloakConfig.super.dockerTag(), "dockerTag");
                this.dockerTagBuildStage = 1;
            }
            return this.dockerTag;
        }

        void dockerTag(String dockerTag) {
            this.dockerTag = dockerTag;
            this.dockerTagBuildStage = 1;
        }

        String realmName() {
            if (this.realmNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.realmNameBuildStage == 0) {
                this.realmNameBuildStage = (byte)-1;
                this.realmName = Objects.requireNonNull(ImmutableKeycloakConfig.super.realmName(), "realmName");
                this.realmNameBuildStage = 1;
            }
            return this.realmName;
        }

        void realmName(String realmName) {
            this.realmName = realmName;
            this.realmNameBuildStage = 1;
        }

        boolean useHttps() {
            if (this.useHttpsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useHttpsBuildStage == 0) {
                this.useHttpsBuildStage = (byte)-1;
                this.useHttps = ImmutableKeycloakConfig.super.useHttps();
                this.useHttpsBuildStage = 1;
            }
            return this.useHttps;
        }

        void useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            this.useHttpsBuildStage = 1;
        }

        List<String> featuresEnabled() {
            if (this.featuresEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featuresEnabledBuildStage == 0) {
                this.featuresEnabledBuildStage = (byte)-1;
                this.featuresEnabled = ImmutableKeycloakConfig.createUnmodifiableList(false, ImmutableKeycloakConfig.createSafeList(ImmutableKeycloakConfig.super.featuresEnabled(), true, false));
                this.featuresEnabledBuildStage = 1;
            }
            return this.featuresEnabled;
        }

        void featuresEnabled(List<String> featuresEnabled) {
            this.featuresEnabled = featuresEnabled;
            this.featuresEnabledBuildStage = 1;
        }

        Consumer<RealmRepresentation> realmConfigure() {
            if (this.realmConfigureBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.realmConfigureBuildStage == 0) {
                this.realmConfigureBuildStage = (byte)-1;
                this.realmConfigure = Objects.requireNonNull(ImmutableKeycloakConfig.super.realmConfigure(), "realmConfigure");
                this.realmConfigureBuildStage = 1;
            }
            return this.realmConfigure;
        }

        void realmConfigure(Consumer<RealmRepresentation> realmConfigure) {
            this.realmConfigure = realmConfigure;
            this.realmConfigureBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.dockerImageBuildStage == -1) {
                attributes.add("dockerImage");
            }
            if (this.dockerTagBuildStage == -1) {
                attributes.add("dockerTag");
            }
            if (this.realmNameBuildStage == -1) {
                attributes.add("realmName");
            }
            if (this.useHttpsBuildStage == -1) {
                attributes.add("useHttps");
            }
            if (this.featuresEnabledBuildStage == -1) {
                attributes.add("featuresEnabled");
            }
            if (this.realmConfigureBuildStage == -1) {
                attributes.add("realmConfigure");
            }
            return "Cannot build KeycloakConfig, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CustomKeycloakContainer.KeycloakConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CustomKeycloakContainer.KeycloakConfig.Builder {
        private static final long OPT_BIT_USE_HTTPS = 1L;
        private static final long OPT_BIT_FEATURES_ENABLED = 2L;
        private long optBits;
        @Nullable
        private String dockerImage;
        @Nullable
        private String dockerTag;
        @Nullable
        private String realmName;
        private boolean useHttps;
        private List<String> featuresEnabled = new ArrayList<String>();
        @Nullable
        private String dockerNetworkId;
        @Nullable
        private Consumer<RealmRepresentation> realmConfigure;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CustomKeycloakContainer.KeycloakConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.dockerImage(instance.dockerImage());
            this.dockerTag(instance.dockerTag());
            this.realmName(instance.realmName());
            this.useHttps(instance.useHttps());
            this.addAllFeaturesEnabled(instance.featuresEnabled());
            String dockerNetworkIdValue = instance.dockerNetworkId();
            if (dockerNetworkIdValue != null) {
                this.dockerNetworkId(dockerNetworkIdValue);
            }
            this.realmConfigure((Consumer)instance.realmConfigure());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder dockerImage(String dockerImage) {
            this.dockerImage = Objects.requireNonNull(dockerImage, "dockerImage");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder dockerTag(String dockerTag) {
            this.dockerTag = Objects.requireNonNull(dockerTag, "dockerTag");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder realmName(String realmName) {
            this.realmName = Objects.requireNonNull(realmName, "realmName");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFeaturesEnabled(String element) {
            this.featuresEnabled.add(Objects.requireNonNull(element, "featuresEnabled element"));
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFeaturesEnabled(String ... elements) {
            for (String element : elements) {
                this.featuresEnabled.add(Objects.requireNonNull(element, "featuresEnabled element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder featuresEnabled(Iterable<String> elements) {
            this.featuresEnabled.clear();
            return this.addAllFeaturesEnabled(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFeaturesEnabled(Iterable<String> elements) {
            for (String element : elements) {
                this.featuresEnabled.add(Objects.requireNonNull(element, "featuresEnabled element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder dockerNetworkId(@Nullable String dockerNetworkId) {
            this.dockerNetworkId = dockerNetworkId;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder realmConfigure(Consumer<RealmRepresentation> realmConfigure) {
            this.realmConfigure = Objects.requireNonNull(realmConfigure, "realmConfigure");
            return this;
        }

        @Override
        public ImmutableKeycloakConfig build() {
            return new ImmutableKeycloakConfig(this);
        }

        private boolean useHttpsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean featuresEnabledIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

