/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.gcs;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import jakarta.annotation.Nullable;
import java.time.Instant;
import org.immutables.value.Value;
import org.projectnessie.objectstoragemock.gcs.ImmutableStorageObject;

@JsonSerialize(as=ImmutableStorageObject.class)
@JsonDeserialize(as=ImmutableStorageObject.class)
@Value.Immutable
public interface StorageObject {
    default public String kind() {
        return "storage#object";
    }

    public String id();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String selfLink();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String mediaLink();

    public String name();

    public String bucket();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long generation();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long metageneration();

    public String contentType();

    public String storageClass();

    @JsonSerialize(using=ToStringSerializer.class)
    public long size();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant softDeleteTime();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant hardDeleteTime();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String md5Hash();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String contentEncoding();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String contentDisposition();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String contentLanguage();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String cacheControl();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String crc32c();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer componentCount();

    public String etag();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String kmsKeyName();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean temporaryHold();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean eventBasedHold();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String retentionExpirationTime();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode retention();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant timeCreated();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant updated();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant timeDeleted();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant timeStorageClassUpdated();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant customTime();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode metadata();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode acl();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode customerEncryption();
}

