/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.adlsgen2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.adlsgen2.Path;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Path", generator="Immutables")
@Immutable
public final class ImmutablePath
implements Path {
    private final long contentLength;
    private final String etag;
    @Nullable
    private final String group;
    private final boolean directory;
    private final String lastModified;
    private final long creationTime;
    private final String name;
    @Nullable
    private final String owner;
    @Nullable
    private final String permissions;
    @Nullable
    private final String msEncryptionContext;
    @Nullable
    private final String msEncryptionKeySha256;
    @Nullable
    private final String msEncryptionScope;
    @Nullable
    private final Boolean msServerEncrypted;
    private transient int hashCode;

    private ImmutablePath(long contentLength, String etag, @Nullable String group, boolean directory, String lastModified, long creationTime, String name, @Nullable String owner, @Nullable String permissions, @Nullable String msEncryptionContext, @Nullable String msEncryptionKeySha256, @Nullable String msEncryptionScope, @Nullable Boolean msServerEncrypted) {
        this.contentLength = contentLength;
        this.etag = Objects.requireNonNull(etag, "etag");
        this.group = group;
        this.directory = directory;
        this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
        this.creationTime = creationTime;
        this.name = Objects.requireNonNull(name, "name");
        this.owner = owner;
        this.permissions = permissions;
        this.msEncryptionContext = msEncryptionContext;
        this.msEncryptionKeySha256 = msEncryptionKeySha256;
        this.msEncryptionScope = msEncryptionScope;
        this.msServerEncrypted = msServerEncrypted;
    }

    private ImmutablePath(ImmutablePath original, long contentLength, String etag, @Nullable String group, boolean directory, String lastModified, long creationTime, String name, @Nullable String owner, @Nullable String permissions, @Nullable String msEncryptionContext, @Nullable String msEncryptionKeySha256, @Nullable String msEncryptionScope, @Nullable Boolean msServerEncrypted) {
        this.contentLength = contentLength;
        this.etag = etag;
        this.group = group;
        this.directory = directory;
        this.lastModified = lastModified;
        this.creationTime = creationTime;
        this.name = name;
        this.owner = owner;
        this.permissions = permissions;
        this.msEncryptionContext = msEncryptionContext;
        this.msEncryptionKeySha256 = msEncryptionKeySha256;
        this.msEncryptionScope = msEncryptionScope;
        this.msServerEncrypted = msServerEncrypted;
    }

    @Override
    @JsonProperty
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    @JsonProperty(value="eTag")
    public String etag() {
        return this.etag;
    }

    @Override
    @JsonProperty
    @Nullable
    public String group() {
        return this.group;
    }

    @Override
    @JsonProperty
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    @JsonProperty
    public String lastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty
    public long creationTime() {
        return this.creationTime;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String owner() {
        return this.owner;
    }

    @Override
    @JsonProperty
    @Nullable
    public String permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty(value="x-ms-encryption-context")
    @Nullable
    public String msEncryptionContext() {
        return this.msEncryptionContext;
    }

    @Override
    @JsonProperty(value="x-ms-encryption-key-sha256")
    @Nullable
    public String msEncryptionKeySha256() {
        return this.msEncryptionKeySha256;
    }

    @Override
    @JsonProperty(value="x-ms-encryption-scope")
    @Nullable
    public String msEncryptionScope() {
        return this.msEncryptionScope;
    }

    @Override
    @JsonProperty(value="x-ms-server-encrypted")
    @Nullable
    public Boolean msServerEncrypted() {
        return this.msServerEncrypted;
    }

    public final ImmutablePath withContentLength(long value) {
        if (this.contentLength == value) {
            return this;
        }
        return new ImmutablePath(this, value, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withEtag(String value) {
        String newValue = Objects.requireNonNull(value, "etag");
        if (this.etag.equals(newValue)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, newValue, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withGroup(@Nullable String value) {
        if (Objects.equals(this.group, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, value, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withDirectory(boolean value) {
        if (this.directory == value) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, value, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withLastModified(String value) {
        String newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified.equals(newValue)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, newValue, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withCreationTime(long value) {
        if (this.creationTime == value) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, value, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, newValue, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withOwner(@Nullable String value) {
        if (Objects.equals(this.owner, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, value, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withPermissions(@Nullable String value) {
        if (Objects.equals(this.permissions, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, value, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withMsEncryptionContext(@Nullable String value) {
        if (Objects.equals(this.msEncryptionContext, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, value, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withMsEncryptionKeySha256(@Nullable String value) {
        if (Objects.equals(this.msEncryptionKeySha256, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, value, this.msEncryptionScope, this.msServerEncrypted);
    }

    public final ImmutablePath withMsEncryptionScope(@Nullable String value) {
        if (Objects.equals(this.msEncryptionScope, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, value, this.msServerEncrypted);
    }

    public final ImmutablePath withMsServerEncrypted(@Nullable Boolean value) {
        if (Objects.equals(this.msServerEncrypted, value)) {
            return this;
        }
        return new ImmutablePath(this, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePath && this.equalTo(0, (ImmutablePath)another);
    }

    private boolean equalTo(int synthetic, ImmutablePath another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.contentLength == another.contentLength && this.etag.equals(another.etag) && Objects.equals(this.group, another.group) && this.directory == another.directory && this.lastModified.equals(another.lastModified) && this.creationTime == another.creationTime && this.name.equals(another.name) && Objects.equals(this.owner, another.owner) && Objects.equals(this.permissions, another.permissions) && Objects.equals(this.msEncryptionContext, another.msEncryptionContext) && Objects.equals(this.msEncryptionKeySha256, another.msEncryptionKeySha256) && Objects.equals(this.msEncryptionScope, another.msEncryptionScope) && Objects.equals(this.msServerEncrypted, another.msServerEncrypted);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.contentLength);
        h += (h << 5) + this.etag.hashCode();
        h += (h << 5) + Objects.hashCode(this.group);
        h += (h << 5) + Boolean.hashCode(this.directory);
        h += (h << 5) + this.lastModified.hashCode();
        h += (h << 5) + Long.hashCode(this.creationTime);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.owner);
        h += (h << 5) + Objects.hashCode(this.permissions);
        h += (h << 5) + Objects.hashCode(this.msEncryptionContext);
        h += (h << 5) + Objects.hashCode(this.msEncryptionKeySha256);
        h += (h << 5) + Objects.hashCode(this.msEncryptionScope);
        h += (h << 5) + Objects.hashCode(this.msServerEncrypted);
        return h;
    }

    public String toString() {
        return "Path{contentLength=" + this.contentLength + ", etag=" + this.etag + ", group=" + this.group + ", directory=" + this.directory + ", lastModified=" + this.lastModified + ", creationTime=" + this.creationTime + ", name=" + this.name + ", owner=" + this.owner + ", permissions=" + this.permissions + ", msEncryptionContext=" + this.msEncryptionContext + ", msEncryptionKeySha256=" + this.msEncryptionKeySha256 + ", msEncryptionScope=" + this.msEncryptionScope + ", msServerEncrypted=" + this.msServerEncrypted + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePath fromJson(Json json) {
        Builder builder = ImmutablePath.builder();
        if (json.contentLengthIsSet) {
            builder.contentLength(json.contentLength);
        }
        if (json.etag != null) {
            builder.etag(json.etag);
        }
        if (json.group != null) {
            builder.group(json.group);
        }
        if (json.directoryIsSet) {
            builder.directory(json.directory);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.creationTimeIsSet) {
            builder.creationTime(json.creationTime);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.permissions != null) {
            builder.permissions(json.permissions);
        }
        if (json.msEncryptionContext != null) {
            builder.msEncryptionContext(json.msEncryptionContext);
        }
        if (json.msEncryptionKeySha256 != null) {
            builder.msEncryptionKeySha256(json.msEncryptionKeySha256);
        }
        if (json.msEncryptionScope != null) {
            builder.msEncryptionScope(json.msEncryptionScope);
        }
        if (json.msServerEncrypted != null) {
            builder.msServerEncrypted(json.msServerEncrypted);
        }
        return builder.build();
    }

    public static ImmutablePath of(long contentLength, String etag, @Nullable String group, boolean directory, String lastModified, long creationTime, String name, @Nullable String owner, @Nullable String permissions, @Nullable String msEncryptionContext, @Nullable String msEncryptionKeySha256, @Nullable String msEncryptionScope, @Nullable Boolean msServerEncrypted) {
        return new ImmutablePath(contentLength, etag, group, directory, lastModified, creationTime, name, owner, permissions, msEncryptionContext, msEncryptionKeySha256, msEncryptionScope, msServerEncrypted);
    }

    public static ImmutablePath copyOf(Path instance) {
        if (instance instanceof ImmutablePath) {
            return (ImmutablePath)instance;
        }
        return ImmutablePath.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Path", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_LENGTH = 1L;
        private static final long INIT_BIT_ETAG = 2L;
        private static final long INIT_BIT_DIRECTORY = 4L;
        private static final long INIT_BIT_LAST_MODIFIED = 8L;
        private static final long INIT_BIT_CREATION_TIME = 16L;
        private static final long INIT_BIT_NAME = 32L;
        private long initBits = 63L;
        private long contentLength;
        @javax.annotation.Nullable
        private String etag;
        @javax.annotation.Nullable
        private String group;
        private boolean directory;
        @javax.annotation.Nullable
        private String lastModified;
        private long creationTime;
        @javax.annotation.Nullable
        private String name;
        @javax.annotation.Nullable
        private String owner;
        @javax.annotation.Nullable
        private String permissions;
        @javax.annotation.Nullable
        private String msEncryptionContext;
        @javax.annotation.Nullable
        private String msEncryptionKeySha256;
        @javax.annotation.Nullable
        private String msEncryptionScope;
        @javax.annotation.Nullable
        private Boolean msServerEncrypted;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Path instance) {
            Boolean msServerEncryptedValue;
            String msEncryptionScopeValue;
            String msEncryptionKeySha256Value;
            String msEncryptionContextValue;
            String permissionsValue;
            Objects.requireNonNull(instance, "instance");
            this.contentLength(instance.contentLength());
            this.etag(instance.etag());
            String groupValue = instance.group();
            if (groupValue != null) {
                this.group(groupValue);
            }
            this.directory(instance.isDirectory());
            this.lastModified(instance.lastModified());
            this.creationTime(instance.creationTime());
            this.name(instance.name());
            String ownerValue = instance.owner();
            if (ownerValue != null) {
                this.owner(ownerValue);
            }
            if ((permissionsValue = instance.permissions()) != null) {
                this.permissions(permissionsValue);
            }
            if ((msEncryptionContextValue = instance.msEncryptionContext()) != null) {
                this.msEncryptionContext(msEncryptionContextValue);
            }
            if ((msEncryptionKeySha256Value = instance.msEncryptionKeySha256()) != null) {
                this.msEncryptionKeySha256(msEncryptionKeySha256Value);
            }
            if ((msEncryptionScopeValue = instance.msEncryptionScope()) != null) {
                this.msEncryptionScope(msEncryptionScopeValue);
            }
            if ((msServerEncryptedValue = instance.msServerEncrypted()) != null) {
                this.msServerEncrypted(msServerEncryptedValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder contentLength(long contentLength) {
            this.contentLength = contentLength;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="eTag")
        @CanIgnoreReturnValue
        public final Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag, "etag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder group(@Nullable String group) {
            this.group = group;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder directory(boolean directory) {
            this.directory = directory;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder lastModified(String lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder creationTime(long creationTime) {
            this.creationTime = creationTime;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder owner(@Nullable String owner) {
            this.owner = owner;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permissions(@Nullable String permissions) {
            this.permissions = permissions;
            return this;
        }

        @JsonProperty(value="x-ms-encryption-context")
        @CanIgnoreReturnValue
        public final Builder msEncryptionContext(@Nullable String msEncryptionContext) {
            this.msEncryptionContext = msEncryptionContext;
            return this;
        }

        @JsonProperty(value="x-ms-encryption-key-sha256")
        @CanIgnoreReturnValue
        public final Builder msEncryptionKeySha256(@Nullable String msEncryptionKeySha256) {
            this.msEncryptionKeySha256 = msEncryptionKeySha256;
            return this;
        }

        @JsonProperty(value="x-ms-encryption-scope")
        @CanIgnoreReturnValue
        public final Builder msEncryptionScope(@Nullable String msEncryptionScope) {
            this.msEncryptionScope = msEncryptionScope;
            return this;
        }

        @JsonProperty(value="x-ms-server-encrypted")
        @CanIgnoreReturnValue
        public final Builder msServerEncrypted(@Nullable Boolean msServerEncrypted) {
            this.msServerEncrypted = msServerEncrypted;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 63L;
            this.contentLength = 0L;
            this.etag = null;
            this.group = null;
            this.directory = false;
            this.lastModified = null;
            this.creationTime = 0L;
            this.name = null;
            this.owner = null;
            this.permissions = null;
            this.msEncryptionContext = null;
            this.msEncryptionKeySha256 = null;
            this.msEncryptionScope = null;
            this.msServerEncrypted = null;
            return this;
        }

        public ImmutablePath build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePath(null, this.contentLength, this.etag, this.group, this.directory, this.lastModified, this.creationTime, this.name, this.owner, this.permissions, this.msEncryptionContext, this.msEncryptionKeySha256, this.msEncryptionScope, this.msServerEncrypted);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentLength");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("etag");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("directory");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lastModified");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("creationTime");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Path, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Path", generator="Immutables")
    static final class Json
    implements Path {
        long contentLength;
        boolean contentLengthIsSet;
        @javax.annotation.Nullable
        String etag;
        @javax.annotation.Nullable
        String group;
        boolean directory;
        boolean directoryIsSet;
        @javax.annotation.Nullable
        String lastModified;
        long creationTime;
        boolean creationTimeIsSet;
        @javax.annotation.Nullable
        String name;
        @javax.annotation.Nullable
        String owner;
        @javax.annotation.Nullable
        String permissions;
        @javax.annotation.Nullable
        String msEncryptionContext;
        @javax.annotation.Nullable
        String msEncryptionKeySha256;
        @javax.annotation.Nullable
        String msEncryptionScope;
        @javax.annotation.Nullable
        Boolean msServerEncrypted;

        Json() {
        }

        @JsonProperty
        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
            this.contentLengthIsSet = true;
        }

        @JsonProperty(value="eTag")
        public void setEtag(String etag) {
            this.etag = etag;
        }

        @JsonProperty
        public void setGroup(@Nullable String group) {
            this.group = group;
        }

        @JsonProperty
        public void setDirectory(boolean directory) {
            this.directory = directory;
            this.directoryIsSet = true;
        }

        @JsonProperty
        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty
        public void setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            this.creationTimeIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setOwner(@Nullable String owner) {
            this.owner = owner;
        }

        @JsonProperty
        public void setPermissions(@Nullable String permissions) {
            this.permissions = permissions;
        }

        @JsonProperty(value="x-ms-encryption-context")
        public void setMsEncryptionContext(@Nullable String msEncryptionContext) {
            this.msEncryptionContext = msEncryptionContext;
        }

        @JsonProperty(value="x-ms-encryption-key-sha256")
        public void setMsEncryptionKeySha256(@Nullable String msEncryptionKeySha256) {
            this.msEncryptionKeySha256 = msEncryptionKeySha256;
        }

        @JsonProperty(value="x-ms-encryption-scope")
        public void setMsEncryptionScope(@Nullable String msEncryptionScope) {
            this.msEncryptionScope = msEncryptionScope;
        }

        @JsonProperty(value="x-ms-server-encrypted")
        public void setMsServerEncrypted(@Nullable Boolean msServerEncrypted) {
            this.msServerEncrypted = msServerEncrypted;
        }

        @Override
        public long contentLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String etag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String group() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long creationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String msEncryptionContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String msEncryptionKeySha256() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String msEncryptionScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean msServerEncrypted() {
            throw new UnsupportedOperationException();
        }
    }
}

