/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.Owner;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Owner", generator="Immutables")
@Immutable
public final class ImmutableOwner
implements Owner {
    private final long id;
    private final String displayName;

    private ImmutableOwner(long id, String displayName) {
        this.id = id;
        this.displayName = Objects.requireNonNull(displayName, "displayName");
    }

    private ImmutableOwner(ImmutableOwner original, long id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    @Override
    @JsonProperty(value="ID")
    public long id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="DisplayName")
    public String displayName() {
        return this.displayName;
    }

    public final ImmutableOwner withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableOwner(this, value, this.displayName);
    }

    public final ImmutableOwner withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (this.displayName.equals(newValue)) {
            return this;
        }
        return new ImmutableOwner(this, this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOwner && this.equalTo(0, (ImmutableOwner)another);
    }

    private boolean equalTo(int synthetic, ImmutableOwner another) {
        return this.id == another.id && this.displayName.equals(another.displayName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.id);
        h += (h << 5) + this.displayName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Owner").omitNullValues().add("id", this.id).add("displayName", (Object)this.displayName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOwner fromJson(Json json) {
        Builder builder = ImmutableOwner.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        return builder.build();
    }

    public static ImmutableOwner of(long id, String displayName) {
        return new ImmutableOwner(id, displayName);
    }

    public static ImmutableOwner copyOf(Owner instance) {
        if (instance instanceof ImmutableOwner) {
            return (ImmutableOwner)instance;
        }
        return ImmutableOwner.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Owner", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DISPLAY_NAME = 2L;
        private long initBits = 3L;
        private long id;
        @Nullable
        private String displayName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Owner instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.displayName(instance.displayName());
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="DisplayName")
        @CanIgnoreReturnValue
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOwner build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOwner(null, this.id, this.displayName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("displayName");
            }
            return "Cannot build Owner, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Owner", generator="Immutables")
    static final class Json
    implements Owner {
        long id;
        boolean idIsSet;
        @Nullable
        String displayName;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="DisplayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String displayName() {
            throw new UnsupportedOperationException();
        }
    }
}

