/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import io.quarkus.arc.profile.IfBuildProfile;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.ObjectStorageMock;
import org.projectnessie.objectstoragemock.Range;
import org.projectnessie.objectstoragemock.adlsgen2.DataLakeStorageError;
import org.projectnessie.objectstoragemock.adlsgen2.ImmutablePath;
import org.projectnessie.objectstoragemock.adlsgen2.ImmutablePathList;
import org.projectnessie.objectstoragemock.adlsgen2.UpdateAction;
import org.projectnessie.objectstoragemock.util.Holder;
import org.projectnessie.objectstoragemock.util.PrefixSpliterator;
import org.projectnessie.objectstoragemock.util.StartAfterSpliterator;

@Path(value="/adlsgen2/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@IfBuildProfile(value="never-include")
public class AdlsGen2Resource {
    @Inject
    ObjectStorageMock mockServer;
    static final String delimiter = "/";

    @PUT
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}/{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/xml"})
    public Response create(@PathParam(value="filesystem") String filesystem, @PathParam(value="path") String path, @HeaderParam(value="x-ms-blob-type") String msBlobType, @HeaderParam(value="x-ms-blob-content-type") String msBlobContentType, @HeaderParam(value="Accept") String accept, InputStream input) {
        String normalizedPath = this.stripLeadingSlash(path);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            Bucket.ObjectUpdater updater = b.updater().update(normalizedPath, Bucket.UpdaterMode.CREATE_NEW);
            if ("BlockBlob".equals(msBlobType) && "application/xml".equals(accept)) {
                updater.append(0L, input);
                if (msBlobContentType != null) {
                    updater.setContentType(msBlobContentType);
                }
            }
            updater.commit();
            return Response.status((Response.Status)Response.Status.CREATED).build();
        });
    }

    @PATCH
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}/{path:.*}")
    @Consumes(value={"*/*"})
    public Response update(@PathParam(value="filesystem") String filesystem, @PathParam(value="path") String path, @QueryParam(value="action") UpdateAction action, @QueryParam(value="flush") @DefaultValue(value="false") boolean flush, @HeaderParam(value="x-ms-content-type") String msContentType, InputStream input) {
        String normalizedPath = this.stripLeadingSlash(path);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            boolean doFlush;
            if (!action.appendOrFlush()) {
                return AdlsGen2Resource.notImplemented();
            }
            Bucket.ObjectUpdater updater = b.updater().update(normalizedPath, Bucket.UpdaterMode.UPDATE);
            if (updater == null) {
                return AdlsGen2Resource.keyNotFound();
            }
            if (action == UpdateAction.append) {
                updater.append(0L, input);
            }
            boolean bl = doFlush = action == UpdateAction.flush || flush;
            if (doFlush) {
                updater.flush().setContentType(msContentType != null ? msContentType : "application/octet-stream");
            }
            updater.commit();
            return Response.status((Response.Status)(doFlush ? Response.Status.OK : Response.Status.ACCEPTED)).build();
        });
    }

    @GET
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}/{path:.*}")
    @Produces(value={"*/*"})
    public Response read(@PathParam(value="filesystem") String filesystem, @PathParam(value="path") String path, @HeaderParam(value="Range") Range range) {
        String normalizedPath = this.stripLeadingSlash(path);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            String contentType;
            MockObject obj = b.object().retrieve(normalizedPath);
            if (obj == null) {
                return AdlsGen2Resource.keyNotFound();
            }
            switch (obj.contentType()) {
                case "text/plain": 
                case "application/json": {
                    contentType = obj.contentType();
                    break;
                }
                default: {
                    contentType = "application/octet-stream";
                }
            }
            StreamingOutput stream = output -> obj.writer().write(range, output);
            long start = range != null ? range.start() : 0L;
            long end = range != null ? Math.min(range.end(), obj.contentLength()) : obj.contentLength();
            return Response.ok((Object)stream).tag(obj.etag()).type(contentType).header("Content-Length", (Object)obj.contentLength()).header("Content-Range", (Object)("bytes " + start + "-" + end + delimiter + obj.contentLength())).lastModified(new Date(obj.lastModified())).build();
        });
    }

    @HEAD
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}/{path:.*}")
    @Produces(value={"*/*"})
    public Response getProperties(@PathParam(value="filesystem") String filesystem, @PathParam(value="path") String path) {
        String normalizedPath = this.stripLeadingSlash(path);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            MockObject obj = b.object().retrieve(normalizedPath);
            if (obj == null) {
                return AdlsGen2Resource.keyNotFound();
            }
            return Response.ok().tag(obj.etag()).type(obj.contentType()).header("Content-Length", (Object)obj.contentLength()).lastModified(new Date(obj.lastModified())).build();
        });
    }

    @DELETE
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}/{path:.*}")
    @Consumes(value={"*/*"})
    public Response delete(@PathParam(value="filesystem") String filesystem, @PathParam(value="path") String path, @QueryParam(value="continuation") String continuationToken, @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive) {
        String normalizedPath = this.stripLeadingSlash(path);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            if (recursive) {
                try (Stream<Bucket.ListElement> listStream = b.lister().list(normalizedPath, continuationToken);){
                    AdlsGen2Resource.splitForDirectory(normalizedPath, continuationToken, listStream).forEachRemaining(e -> b.deleter().delete(e.key()));
                }
            } else {
                MockObject o = b.object().retrieve(normalizedPath);
                if (o == null) {
                    return AdlsGen2Resource.keyNotFound();
                }
                if (!b.deleter().delete(normalizedPath)) {
                    return AdlsGen2Resource.keyNotFound();
                }
            }
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="/{filesystem:[$a-z0-9](?!.*--)[-a-z0-9]{1,61}[a-z0-9]}")
    public Response list(@PathParam(value="filesystem") String filesystem, @QueryParam(value="directory") String directory, @QueryParam(value="continuation") String continuationToken, @QueryParam(value="maxResults") Integer maxResults) {
        String normalizedPath = this.stripLeadingSlash(directory);
        return this.withFilesystem(filesystem, normalizedPath, b -> {
            try (Stream<Bucket.ListElement> listStream = b.lister().list(normalizedPath, continuationToken);){
                ImmutablePathList.Builder result = ImmutablePathList.builder();
                int maxKeys = maxResults != null ? maxResults : Integer.MAX_VALUE;
                String nextContinuationToken = null;
                int keyCount = 0;
                String lastKey = null;
                Spliterator<Bucket.ListElement> split = AdlsGen2Resource.splitForDirectory(normalizedPath, continuationToken, listStream);
                Holder current = new Holder();
                while (split.tryAdvance(current::set)) {
                    if (keyCount == maxKeys) {
                        nextContinuationToken = lastKey;
                        break;
                    }
                    String key = ((Bucket.ListElement)current.get()).key();
                    MockObject obj = ((Bucket.ListElement)current.get()).object();
                    result.addPaths(ImmutablePath.builder().name(key).etag(obj.etag()).contentLength(obj.contentLength()).lastModified(DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(obj.lastModified()), ZoneId.of("UTC")))).creationTime(1000L).directory(false).build());
                    ++keyCount;
                    lastKey = key;
                }
                Response.ResponseBuilder response = Response.ok((Object)result.build());
                if (nextContinuationToken != null) {
                    response.header("x-ms-continuation", nextContinuationToken);
                }
                Response response2 = response.build();
                return response2;
            }
        });
    }

    private String stripLeadingSlash(String path) {
        if (path == null) {
            return "";
        }
        return path.startsWith(delimiter) ? path.substring(1) : path;
    }

    private static Spliterator<Bucket.ListElement> splitForDirectory(String directory, String offset, Stream<Bucket.ListElement> listStream) {
        Spliterator<Bucket.ListElement> split = listStream.spliterator();
        if (offset != null) {
            split = new StartAfterSpliterator<Bucket.ListElement>(split, e -> e.key().compareTo(offset) >= 0);
        }
        if (directory == null || ((String)directory).isEmpty()) {
            return split;
        }
        if (!((String)directory).endsWith(delimiter)) {
            directory = (String)directory + delimiter;
        }
        String directoryPrefix = directory;
        return new PrefixSpliterator<Bucket.ListElement>(split, e -> e.key().startsWith(directoryPrefix));
    }

    private static Response bucketNotFound() {
        return AdlsGen2Resource.dataLakeStorageError(Response.Status.NOT_FOUND, "FilesystemNotFound", "The specified filesystem does not exist.");
    }

    private static Response keyNotFound() {
        return AdlsGen2Resource.dataLakeStorageError(Response.Status.NOT_FOUND, "PathNotFound", "The specified path does not exist.");
    }

    private static Response accessDenied() {
        return AdlsGen2Resource.dataLakeStorageError(Response.Status.FORBIDDEN, "Forbidden", "Access Denied.");
    }

    private static Response dataLakeStorageError(Response.Status status, String code, String message) {
        return Response.status((Response.Status)status).header("x-ms-error-code", (Object)code).type("application/json").entity((Object)DataLakeStorageError.dataLakeStorageErrorObj(code, message).error()).build();
    }

    private static Response notImplemented() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    private Response withFilesystem(String filesystem, String path, Function<Bucket, Response> worker) {
        if (!this.mockServer.accessCheckHandler().accessAllowed(path)) {
            return AdlsGen2Resource.accessDenied();
        }
        Bucket bucket = this.mockServer.buckets().get(filesystem);
        if (bucket == null) {
            return AdlsGen2Resource.bucketNotFound();
        }
        return worker.apply(bucket);
    }
}

