/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.Tag;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tag", generator="Immutables")
@Immutable
public final class ImmutableTag
implements Tag {
    private final String key;
    private final String value;

    private ImmutableTag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="Value")
    public String value() {
        return this.value;
    }

    public final ImmutableTag withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(newValue, this.value);
    }

    public final ImmutableTag withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTag && this.equalTo(0, (ImmutableTag)another);
    }

    private boolean equalTo(int synthetic, ImmutableTag another) {
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Tag").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTag fromJson(Json json) {
        Builder builder = ImmutableTag.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableTag copyOf(Tag instance) {
        if (instance instanceof ImmutableTag) {
            return (ImmutableTag)instance;
        }
        return ImmutableTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tag instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTag build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTag(this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Tag, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Tag", generator="Immutables")
    static final class Json
    implements Tag {
        @Nullable
        String key;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="Value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }
    }
}

