/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.util;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class StartAfterSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> matcher;
    private boolean didMatch;
    private boolean exhausted;
    private T value;

    public StartAfterSpliterator(Spliterator<T> source, Predicate<T> matcher) {
        super(source.estimateSize(), source.characteristics());
        this.source = source;
        this.matcher = matcher;
    }

    private void set(T value) {
        this.value = value;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        while (!this.exhausted) {
            if (!this.source.tryAdvance(this::set)) {
                this.exhausted = true;
                return false;
            }
            if (this.didMatch) {
                action.accept(this.value);
                return true;
            }
            this.didMatch = this.matcher.test(this.value);
        }
        return false;
    }
}

