/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.CompletedPartBase;
import org.projectnessie.objectstoragemock.s3.EtagDeserializer;
import org.projectnessie.objectstoragemock.s3.EtagSerializer;
import org.projectnessie.objectstoragemock.s3.Part;

@Generated(from="Part", generator="Immutables")
public final class ImmutablePart
implements Part {
    private final Integer partNumber;
    private final String etag;
    private final Date lastModified;
    private final Long size;

    private ImmutablePart(Integer partNumber, String etag, Date lastModified, Long size) {
        this.partNumber = partNumber;
        this.etag = etag;
        this.lastModified = lastModified;
        this.size = size;
    }

    @Override
    @JsonProperty(value="PartNumber")
    public Integer partNumber() {
        return this.partNumber;
    }

    @Override
    @JsonProperty(value="ETag")
    @JsonSerialize(using=EtagSerializer.class)
    @JsonDeserialize(using=EtagDeserializer.class)
    public String etag() {
        return this.etag;
    }

    @Override
    @JsonProperty(value="LastModified")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    public Date lastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    public final ImmutablePart withPartNumber(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "partNumber");
        if (this.partNumber.equals(newValue)) {
            return this;
        }
        return new ImmutablePart(newValue, this.etag, this.lastModified, this.size);
    }

    public final ImmutablePart withEtag(String value) {
        String newValue = Objects.requireNonNull(value, "etag");
        if (this.etag.equals(newValue)) {
            return this;
        }
        return new ImmutablePart(this.partNumber, newValue, this.lastModified, this.size);
    }

    public final ImmutablePart withLastModified(Date value) {
        if (this.lastModified == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "lastModified");
        return new ImmutablePart(this.partNumber, this.etag, newValue, this.size);
    }

    public final ImmutablePart withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutablePart(this.partNumber, this.etag, this.lastModified, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePart && this.equalTo(0, (ImmutablePart)another);
    }

    private boolean equalTo(int synthetic, ImmutablePart another) {
        return this.partNumber.equals(another.partNumber) && this.etag.equals(another.etag) && this.lastModified.equals(another.lastModified) && this.size.equals(another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.partNumber.hashCode();
        h += (h << 5) + this.etag.hashCode();
        h += (h << 5) + this.lastModified.hashCode();
        h += (h << 5) + this.size.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Part").omitNullValues().add("partNumber", (Object)this.partNumber).add("etag", (Object)this.etag).add("lastModified", (Object)this.lastModified).add("size", (Object)this.size).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePart fromJson(Json json) {
        Builder builder = ImmutablePart.builder();
        if (json.partNumber != null) {
            builder.partNumber(json.partNumber);
        }
        if (json.etag != null) {
            builder.etag(json.etag);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        return builder.build();
    }

    public static ImmutablePart copyOf(Part instance) {
        if (instance instanceof ImmutablePart) {
            return (ImmutablePart)instance;
        }
        return ImmutablePart.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Part", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PART_NUMBER = 1L;
        private static final long INIT_BIT_ETAG = 2L;
        private static final long INIT_BIT_LAST_MODIFIED = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private long initBits = 15L;
        private Integer partNumber;
        private String etag;
        private Date lastModified;
        private Long size;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Part instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CompletedPartBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            CompletedPartBase instance;
            long bits = 0L;
            if (object instanceof Part) {
                instance = (Part)object;
                if ((bits & 1L) == 0L) {
                    this.partNumber(instance.partNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.etag(instance.etag());
                    bits |= 2L;
                }
                this.lastModified(instance.lastModified());
                this.size(instance.size());
            }
            if (object instanceof CompletedPartBase) {
                instance = (CompletedPartBase)object;
                if ((bits & 1L) == 0L) {
                    this.partNumber(instance.partNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.etag(instance.etag());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="PartNumber")
        @CanIgnoreReturnValue
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = Objects.requireNonNull(partNumber, "partNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ETag")
        @JsonSerialize(using=EtagSerializer.class)
        @JsonDeserialize(using=EtagDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag, "etag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LastModified")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Size")
        @CanIgnoreReturnValue
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutablePart build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePart(this.partNumber, this.etag, this.lastModified, this.size);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("partNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("etag");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastModified");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build Part, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Part", generator="Immutables")
    static final class Json
    implements Part {
        Integer partNumber;
        String etag;
        Date lastModified;
        Long size;

        Json() {
        }

        @JsonProperty(value="PartNumber")
        public void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @JsonProperty(value="ETag")
        @JsonSerialize(using=EtagSerializer.class)
        @JsonDeserialize(using=EtagDeserializer.class)
        public void setEtag(String etag) {
            this.etag = etag;
        }

        @JsonProperty(value="LastModified")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="Size")
        public void setSize(Long size) {
            this.size = size;
        }

        @Override
        public Integer partNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String etag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date lastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long size() {
            throw new UnsupportedOperationException();
        }
    }
}

