/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.ObjectRetriever;

@Generated(from="Bucket", generator="Immutables")
public final class ImmutableBucket
extends Bucket {
    private final String creationDate;
    private final ObjectRetriever object;
    private final Bucket.Deleter deleter;
    private final Bucket.Lister lister;
    private final Bucket.Updater updater;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBucket(Builder builder) {
        if (builder.creationDate != null) {
            this.initShim.creationDate(builder.creationDate);
        }
        if (builder.object != null) {
            this.initShim.object(builder.object);
        }
        if (builder.deleter != null) {
            this.initShim.deleter(builder.deleter);
        }
        if (builder.lister != null) {
            this.initShim.lister(builder.lister);
        }
        if (builder.updater != null) {
            this.initShim.updater(builder.updater);
        }
        this.creationDate = this.initShim.creationDate();
        this.object = this.initShim.object();
        this.deleter = this.initShim.deleter();
        this.lister = this.initShim.lister();
        this.updater = this.initShim.updater();
        this.initShim = null;
    }

    private ImmutableBucket(String creationDate, ObjectRetriever object, Bucket.Deleter deleter, Bucket.Lister lister, Bucket.Updater updater) {
        this.creationDate = creationDate;
        this.object = object;
        this.deleter = deleter;
        this.lister = lister;
        this.updater = updater;
        this.initShim = null;
    }

    @Override
    public String creationDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationDate() : this.creationDate;
    }

    @Override
    public ObjectRetriever object() {
        InitShim shim = this.initShim;
        return shim != null ? shim.object() : this.object;
    }

    @Override
    public Bucket.Deleter deleter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleter() : this.deleter;
    }

    @Override
    public Bucket.Lister lister() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lister() : this.lister;
    }

    @Override
    public Bucket.Updater updater() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updater() : this.updater;
    }

    public final ImmutableBucket withCreationDate(String value) {
        String newValue = Objects.requireNonNull(value, "creationDate");
        if (this.creationDate.equals(newValue)) {
            return this;
        }
        return new ImmutableBucket(newValue, this.object, this.deleter, this.lister, this.updater);
    }

    public final ImmutableBucket withObject(ObjectRetriever value) {
        if (this.object == value) {
            return this;
        }
        ObjectRetriever newValue = Objects.requireNonNull(value, "object");
        return new ImmutableBucket(this.creationDate, newValue, this.deleter, this.lister, this.updater);
    }

    public final ImmutableBucket withDeleter(Bucket.Deleter value) {
        if (this.deleter == value) {
            return this;
        }
        Bucket.Deleter newValue = Objects.requireNonNull(value, "deleter");
        return new ImmutableBucket(this.creationDate, this.object, newValue, this.lister, this.updater);
    }

    public final ImmutableBucket withLister(Bucket.Lister value) {
        if (this.lister == value) {
            return this;
        }
        Bucket.Lister newValue = Objects.requireNonNull(value, "lister");
        return new ImmutableBucket(this.creationDate, this.object, this.deleter, newValue, this.updater);
    }

    public final ImmutableBucket withUpdater(Bucket.Updater value) {
        if (this.updater == value) {
            return this;
        }
        Bucket.Updater newValue = Objects.requireNonNull(value, "updater");
        return new ImmutableBucket(this.creationDate, this.object, this.deleter, this.lister, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBucket && this.equalsByValue((ImmutableBucket)another);
    }

    private boolean equalsByValue(ImmutableBucket another) {
        return this.creationDate.equals(another.creationDate) && this.object.equals(another.object) && this.deleter.equals(another.deleter) && this.lister.equals(another.lister) && this.updater.equals(another.updater);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.deleter.hashCode();
        h += (h << 5) + this.lister.hashCode();
        h += (h << 5) + this.updater.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Bucket").omitNullValues().add("creationDate", (Object)this.creationDate).add("object", (Object)this.object).add("deleter", (Object)this.deleter).add("lister", (Object)this.lister).add("updater", (Object)this.updater).toString();
    }

    public static ImmutableBucket copyOf(Bucket instance) {
        if (instance instanceof ImmutableBucket) {
            return (ImmutableBucket)instance;
        }
        return ImmutableBucket.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bucket", generator="Immutables")
    private final class InitShim {
        private byte creationDateBuildStage = 0;
        private String creationDate;
        private byte objectBuildStage = 0;
        private ObjectRetriever object;
        private byte deleterBuildStage = 0;
        private Bucket.Deleter deleter;
        private byte listerBuildStage = 0;
        private Bucket.Lister lister;
        private byte updaterBuildStage = 0;
        private Bucket.Updater updater;

        private InitShim() {
        }

        String creationDate() {
            if (this.creationDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationDateBuildStage == 0) {
                this.creationDateBuildStage = (byte)-1;
                this.creationDate = Objects.requireNonNull(ImmutableBucket.super.creationDate(), "creationDate");
                this.creationDateBuildStage = 1;
            }
            return this.creationDate;
        }

        void creationDate(String creationDate) {
            this.creationDate = creationDate;
            this.creationDateBuildStage = 1;
        }

        ObjectRetriever object() {
            if (this.objectBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectBuildStage == 0) {
                this.objectBuildStage = (byte)-1;
                this.object = Objects.requireNonNull(ImmutableBucket.super.object(), "object");
                this.objectBuildStage = 1;
            }
            return this.object;
        }

        void object(ObjectRetriever object) {
            this.object = object;
            this.objectBuildStage = 1;
        }

        Bucket.Deleter deleter() {
            if (this.deleterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleterBuildStage == 0) {
                this.deleterBuildStage = (byte)-1;
                this.deleter = Objects.requireNonNull(ImmutableBucket.super.deleter(), "deleter");
                this.deleterBuildStage = 1;
            }
            return this.deleter;
        }

        void deleter(Bucket.Deleter deleter) {
            this.deleter = deleter;
            this.deleterBuildStage = 1;
        }

        Bucket.Lister lister() {
            if (this.listerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.listerBuildStage == 0) {
                this.listerBuildStage = (byte)-1;
                this.lister = Objects.requireNonNull(ImmutableBucket.super.lister(), "lister");
                this.listerBuildStage = 1;
            }
            return this.lister;
        }

        void lister(Bucket.Lister lister) {
            this.lister = lister;
            this.listerBuildStage = 1;
        }

        Bucket.Updater updater() {
            if (this.updaterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updaterBuildStage == 0) {
                this.updaterBuildStage = (byte)-1;
                this.updater = Objects.requireNonNull(ImmutableBucket.super.updater(), "updater");
                this.updaterBuildStage = 1;
            }
            return this.updater;
        }

        void updater(Bucket.Updater updater) {
            this.updater = updater;
            this.updaterBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.creationDateBuildStage == -1) {
                attributes.add("creationDate");
            }
            if (this.objectBuildStage == -1) {
                attributes.add("object");
            }
            if (this.deleterBuildStage == -1) {
                attributes.add("deleter");
            }
            if (this.listerBuildStage == -1) {
                attributes.add("lister");
            }
            if (this.updaterBuildStage == -1) {
                attributes.add("updater");
            }
            return "Cannot build Bucket, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="Bucket", generator="Immutables")
    public static final class Builder {
        private String creationDate;
        private ObjectRetriever object;
        private Bucket.Deleter deleter;
        private Bucket.Lister lister;
        private Bucket.Updater updater;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bucket instance) {
            Objects.requireNonNull(instance, "instance");
            this.creationDate(instance.creationDate());
            this.object(instance.object());
            this.deleter(instance.deleter());
            this.lister(instance.lister());
            this.updater(instance.updater());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creationDate(String creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(ObjectRetriever object) {
            this.object = Objects.requireNonNull(object, "object");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleter(Bucket.Deleter deleter) {
            this.deleter = Objects.requireNonNull(deleter, "deleter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lister(Bucket.Lister lister) {
            this.lister = Objects.requireNonNull(lister, "lister");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder updater(Bucket.Updater updater) {
            this.updater = Objects.requireNonNull(updater, "updater");
            return this;
        }

        public ImmutableBucket build() {
            return new ImmutableBucket(this);
        }
    }
}

