/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.AccessCheckHandler;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.ObjectStorageMock;
import org.projectnessie.objectstoragemock.sts.AssumeRoleHandler;

@Generated(from="ObjectStorageMock", generator="Immutables")
public final class ImmutableObjectStorageMock
extends ObjectStorageMock {
    private final String initAddress;
    private final ImmutableMap<String, Bucket> buckets;
    private final AssumeRoleHandler assumeRoleHandler;
    private final AccessCheckHandler accessCheckHandler;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableObjectStorageMock(Builder builder) {
        this.buckets = builder.buckets.build();
        if (builder.initAddress != null) {
            this.initShim.initAddress(builder.initAddress);
        }
        if (builder.assumeRoleHandler != null) {
            this.initShim.assumeRoleHandler(builder.assumeRoleHandler);
        }
        if (builder.accessCheckHandler != null) {
            this.initShim.accessCheckHandler(builder.accessCheckHandler);
        }
        this.initAddress = this.initShim.initAddress();
        this.assumeRoleHandler = this.initShim.assumeRoleHandler();
        this.accessCheckHandler = this.initShim.accessCheckHandler();
        this.initShim = null;
    }

    private ImmutableObjectStorageMock(String initAddress, ImmutableMap<String, Bucket> buckets, AssumeRoleHandler assumeRoleHandler, AccessCheckHandler accessCheckHandler) {
        this.initAddress = initAddress;
        this.buckets = buckets;
        this.assumeRoleHandler = assumeRoleHandler;
        this.accessCheckHandler = accessCheckHandler;
        this.initShim = null;
    }

    @Override
    public String initAddress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initAddress() : this.initAddress;
    }

    public ImmutableMap<String, Bucket> buckets() {
        return this.buckets;
    }

    @Override
    public AssumeRoleHandler assumeRoleHandler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assumeRoleHandler() : this.assumeRoleHandler;
    }

    @Override
    public AccessCheckHandler accessCheckHandler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.accessCheckHandler() : this.accessCheckHandler;
    }

    public final ImmutableObjectStorageMock withInitAddress(String value) {
        String newValue = Objects.requireNonNull(value, "initAddress");
        if (this.initAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableObjectStorageMock(newValue, this.buckets, this.assumeRoleHandler, this.accessCheckHandler);
    }

    public final ImmutableObjectStorageMock withBuckets(Map<String, ? extends Bucket> entries) {
        if (this.buckets == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableObjectStorageMock(this.initAddress, (ImmutableMap<String, Bucket>)newValue, this.assumeRoleHandler, this.accessCheckHandler);
    }

    public final ImmutableObjectStorageMock withAssumeRoleHandler(AssumeRoleHandler value) {
        if (this.assumeRoleHandler == value) {
            return this;
        }
        AssumeRoleHandler newValue = Objects.requireNonNull(value, "assumeRoleHandler");
        return new ImmutableObjectStorageMock(this.initAddress, this.buckets, newValue, this.accessCheckHandler);
    }

    public final ImmutableObjectStorageMock withAccessCheckHandler(AccessCheckHandler value) {
        if (this.accessCheckHandler == value) {
            return this;
        }
        AccessCheckHandler newValue = Objects.requireNonNull(value, "accessCheckHandler");
        return new ImmutableObjectStorageMock(this.initAddress, this.buckets, this.assumeRoleHandler, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableObjectStorageMock && this.equalsByValue((ImmutableObjectStorageMock)another);
    }

    private boolean equalsByValue(ImmutableObjectStorageMock another) {
        return this.initAddress.equals(another.initAddress) && this.buckets.equals(another.buckets) && this.assumeRoleHandler.equals(another.assumeRoleHandler) && this.accessCheckHandler.equals(another.accessCheckHandler);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.initAddress.hashCode();
        h += (h << 5) + this.buckets.hashCode();
        h += (h << 5) + this.assumeRoleHandler.hashCode();
        h += (h << 5) + this.accessCheckHandler.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ObjectStorageMock").omitNullValues().add("initAddress", (Object)this.initAddress).add("buckets", this.buckets).add("assumeRoleHandler", (Object)this.assumeRoleHandler).add("accessCheckHandler", (Object)this.accessCheckHandler).toString();
    }

    public static ImmutableObjectStorageMock copyOf(ObjectStorageMock instance) {
        if (instance instanceof ImmutableObjectStorageMock) {
            return (ImmutableObjectStorageMock)instance;
        }
        return ImmutableObjectStorageMock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ObjectStorageMock", generator="Immutables")
    private final class InitShim {
        private byte initAddressBuildStage = 0;
        private String initAddress;
        private byte assumeRoleHandlerBuildStage = 0;
        private AssumeRoleHandler assumeRoleHandler;
        private byte accessCheckHandlerBuildStage = 0;
        private AccessCheckHandler accessCheckHandler;

        private InitShim() {
        }

        String initAddress() {
            if (this.initAddressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initAddressBuildStage == 0) {
                this.initAddressBuildStage = (byte)-1;
                this.initAddress = Objects.requireNonNull(ImmutableObjectStorageMock.super.initAddress(), "initAddress");
                this.initAddressBuildStage = 1;
            }
            return this.initAddress;
        }

        void initAddress(String initAddress) {
            this.initAddress = initAddress;
            this.initAddressBuildStage = 1;
        }

        AssumeRoleHandler assumeRoleHandler() {
            if (this.assumeRoleHandlerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assumeRoleHandlerBuildStage == 0) {
                this.assumeRoleHandlerBuildStage = (byte)-1;
                this.assumeRoleHandler = Objects.requireNonNull(ImmutableObjectStorageMock.super.assumeRoleHandler(), "assumeRoleHandler");
                this.assumeRoleHandlerBuildStage = 1;
            }
            return this.assumeRoleHandler;
        }

        void assumeRoleHandler(AssumeRoleHandler assumeRoleHandler) {
            this.assumeRoleHandler = assumeRoleHandler;
            this.assumeRoleHandlerBuildStage = 1;
        }

        AccessCheckHandler accessCheckHandler() {
            if (this.accessCheckHandlerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.accessCheckHandlerBuildStage == 0) {
                this.accessCheckHandlerBuildStage = (byte)-1;
                this.accessCheckHandler = Objects.requireNonNull(ImmutableObjectStorageMock.super.accessCheckHandler(), "accessCheckHandler");
                this.accessCheckHandlerBuildStage = 1;
            }
            return this.accessCheckHandler;
        }

        void accessCheckHandler(AccessCheckHandler accessCheckHandler) {
            this.accessCheckHandler = accessCheckHandler;
            this.accessCheckHandlerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.initAddressBuildStage == -1) {
                attributes.add("initAddress");
            }
            if (this.assumeRoleHandlerBuildStage == -1) {
                attributes.add("assumeRoleHandler");
            }
            if (this.accessCheckHandlerBuildStage == -1) {
                attributes.add("accessCheckHandler");
            }
            return "Cannot build ObjectStorageMock, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="ObjectStorageMock", generator="Immutables")
    public static final class Builder {
        private String initAddress;
        private ImmutableMap.Builder<String, Bucket> buckets = ImmutableMap.builder();
        private AssumeRoleHandler assumeRoleHandler;
        private AccessCheckHandler accessCheckHandler;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectStorageMock instance) {
            Objects.requireNonNull(instance, "instance");
            this.initAddress(instance.initAddress());
            this.putAllBuckets(instance.buckets());
            this.assumeRoleHandler(instance.assumeRoleHandler());
            this.accessCheckHandler(instance.accessCheckHandler());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initAddress(String initAddress) {
            this.initAddress = Objects.requireNonNull(initAddress, "initAddress");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBuckets(String key, Bucket value) {
            this.buckets.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBuckets(Map.Entry<String, ? extends Bucket> entry) {
            this.buckets.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder buckets(Map<String, ? extends Bucket> entries) {
            this.buckets = ImmutableMap.builder();
            return this.putAllBuckets(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBuckets(Map<String, ? extends Bucket> entries) {
            this.buckets.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assumeRoleHandler(AssumeRoleHandler assumeRoleHandler) {
            this.assumeRoleHandler = Objects.requireNonNull(assumeRoleHandler, "assumeRoleHandler");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessCheckHandler(AccessCheckHandler accessCheckHandler) {
            this.accessCheckHandler = Objects.requireNonNull(accessCheckHandler, "accessCheckHandler");
            return this;
        }

        public ImmutableObjectStorageMock build() {
            return new ImmutableObjectStorageMock(this);
        }
    }
}

