/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.ListBucketResultBase;
import org.projectnessie.objectstoragemock.s3.ListBucketResultV2;
import org.projectnessie.objectstoragemock.s3.Prefix;
import org.projectnessie.objectstoragemock.s3.S3Object;

@Generated(from="ListBucketResultV2", generator="Immutables")
public final class ImmutableListBucketResultV2
implements ListBucketResultV2 {
    private final String name;
    @Nullable
    private final String prefix;
    private final int maxKeys;
    @Nullable
    private final String encodingType;
    private final boolean isTruncated;
    private final List<S3Object> contents;
    private final List<Prefix> commonPrefixes;
    @Nullable
    private final String continuationToken;
    private final int keyCount;
    @Nullable
    private final String nextContinuationToken;
    @Nullable
    private final String startAfter;

    private ImmutableListBucketResultV2(String name, @Nullable String prefix, int maxKeys, @Nullable String encodingType, boolean isTruncated, List<S3Object> contents, List<Prefix> commonPrefixes, @Nullable String continuationToken, int keyCount, @Nullable String nextContinuationToken, @Nullable String startAfter) {
        this.name = name;
        this.prefix = prefix;
        this.maxKeys = maxKeys;
        this.encodingType = encodingType;
        this.isTruncated = isTruncated;
        this.contents = contents;
        this.commonPrefixes = commonPrefixes;
        this.continuationToken = continuationToken;
        this.keyCount = keyCount;
        this.nextContinuationToken = nextContinuationToken;
        this.startAfter = startAfter;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Prefix")
    @Nullable
    public String prefix() {
        return this.prefix;
    }

    @Override
    @JsonProperty(value="MaxKeys")
    public int maxKeys() {
        return this.maxKeys;
    }

    @Override
    @JsonProperty(value="EncodingType")
    @Nullable
    public String encodingType() {
        return this.encodingType;
    }

    @Override
    @JsonProperty(value="IsTruncated")
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    @JsonProperty(value="Contents")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<S3Object> contents() {
        return this.contents;
    }

    @Override
    @JsonProperty(value="CommonPrefixes")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Prefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    @Override
    @JsonProperty(value="ContinuationToken")
    @Nullable
    public String continuationToken() {
        return this.continuationToken;
    }

    @Override
    @JsonProperty(value="KeyCount")
    public int keyCount() {
        return this.keyCount;
    }

    @Override
    @JsonProperty(value="NextContinuationToken")
    @Nullable
    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    @Override
    @JsonProperty(value="StartAfter")
    @Nullable
    public String startAfter() {
        return this.startAfter;
    }

    public final ImmutableListBucketResultV2 withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableListBucketResultV2(newValue, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withPrefix(@Nullable String value) {
        if (Objects.equals(this.prefix, value)) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, value, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withMaxKeys(int value) {
        if (this.maxKeys == value) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, value, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withEncodingType(@Nullable String value) {
        if (Objects.equals(this.encodingType, value)) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, value, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withIsTruncated(boolean value) {
        if (this.isTruncated == value) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, value, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withContents(S3Object ... elements) {
        List<S3Object> newValue = ImmutableListBucketResultV2.createUnmodifiableList(false, ImmutableListBucketResultV2.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, newValue, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withContents(Iterable<? extends S3Object> elements) {
        if (this.contents == elements) {
            return this;
        }
        List<S3Object> newValue = ImmutableListBucketResultV2.createUnmodifiableList(false, ImmutableListBucketResultV2.createSafeList(elements, true, false));
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, newValue, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withCommonPrefixes(Prefix ... elements) {
        List<Prefix> newValue = ImmutableListBucketResultV2.createUnmodifiableList(false, ImmutableListBucketResultV2.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, newValue, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withCommonPrefixes(Iterable<? extends Prefix> elements) {
        if (this.commonPrefixes == elements) {
            return this;
        }
        List<Prefix> newValue = ImmutableListBucketResultV2.createUnmodifiableList(false, ImmutableListBucketResultV2.createSafeList(elements, true, false));
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, newValue, this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withContinuationToken(@Nullable String value) {
        if (Objects.equals(this.continuationToken, value)) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, value, this.keyCount, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withKeyCount(int value) {
        if (this.keyCount == value) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, value, this.nextContinuationToken, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withNextContinuationToken(@Nullable String value) {
        if (Objects.equals(this.nextContinuationToken, value)) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, value, this.startAfter);
    }

    public final ImmutableListBucketResultV2 withStartAfter(@Nullable String value) {
        if (Objects.equals(this.startAfter, value)) {
            return this;
        }
        return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.continuationToken, this.keyCount, this.nextContinuationToken, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListBucketResultV2 && this.equalsByValue((ImmutableListBucketResultV2)another);
    }

    private boolean equalsByValue(ImmutableListBucketResultV2 another) {
        return this.name.equals(another.name) && Objects.equals(this.prefix, another.prefix) && this.maxKeys == another.maxKeys && Objects.equals(this.encodingType, another.encodingType) && this.isTruncated == another.isTruncated && this.contents.equals(another.contents) && this.commonPrefixes.equals(another.commonPrefixes) && Objects.equals(this.continuationToken, another.continuationToken) && this.keyCount == another.keyCount && Objects.equals(this.nextContinuationToken, another.nextContinuationToken) && Objects.equals(this.startAfter, another.startAfter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.prefix);
        h += (h << 5) + this.maxKeys;
        h += (h << 5) + Objects.hashCode(this.encodingType);
        h += (h << 5) + Boolean.hashCode(this.isTruncated);
        h += (h << 5) + this.contents.hashCode();
        h += (h << 5) + this.commonPrefixes.hashCode();
        h += (h << 5) + Objects.hashCode(this.continuationToken);
        h += (h << 5) + this.keyCount;
        h += (h << 5) + Objects.hashCode(this.nextContinuationToken);
        h += (h << 5) + Objects.hashCode(this.startAfter);
        return h;
    }

    public String toString() {
        return "ListBucketResultV2{name=" + this.name + ", prefix=" + this.prefix + ", maxKeys=" + this.maxKeys + ", encodingType=" + this.encodingType + ", isTruncated=" + this.isTruncated + ", contents=" + String.valueOf(this.contents) + ", commonPrefixes=" + String.valueOf(this.commonPrefixes) + ", continuationToken=" + this.continuationToken + ", keyCount=" + this.keyCount + ", nextContinuationToken=" + this.nextContinuationToken + ", startAfter=" + this.startAfter + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableListBucketResultV2 fromJson(Json json) {
        Builder builder = ImmutableListBucketResultV2.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.prefix != null) {
            builder.prefix(json.prefix);
        }
        if (json.maxKeysIsSet) {
            builder.maxKeys(json.maxKeys);
        }
        if (json.encodingType != null) {
            builder.encodingType(json.encodingType);
        }
        if (json.isTruncatedIsSet) {
            builder.isTruncated(json.isTruncated);
        }
        if (json.contents != null) {
            builder.addAllContents(json.contents);
        }
        if (json.commonPrefixes != null) {
            builder.addAllCommonPrefixes(json.commonPrefixes);
        }
        if (json.continuationToken != null) {
            builder.continuationToken(json.continuationToken);
        }
        if (json.keyCountIsSet) {
            builder.keyCount(json.keyCount);
        }
        if (json.nextContinuationToken != null) {
            builder.nextContinuationToken(json.nextContinuationToken);
        }
        if (json.startAfter != null) {
            builder.startAfter(json.startAfter);
        }
        return builder.build();
    }

    public static ImmutableListBucketResultV2 copyOf(ListBucketResultV2 instance) {
        if (instance instanceof ImmutableListBucketResultV2) {
            return (ImmutableListBucketResultV2)instance;
        }
        return ImmutableListBucketResultV2.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListBucketResultV2", generator="Immutables")
    public static final class Builder
    implements ListBucketResultV2.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_MAX_KEYS = 2L;
        private static final long INIT_BIT_IS_TRUNCATED = 4L;
        private static final long INIT_BIT_KEY_COUNT = 8L;
        private long initBits = 15L;
        private String name;
        private String prefix;
        private int maxKeys;
        private String encodingType;
        private boolean isTruncated;
        private List<S3Object> contents = new ArrayList<S3Object>();
        private List<Prefix> commonPrefixes = new ArrayList<Prefix>();
        private String continuationToken;
        private int keyCount;
        private String nextContinuationToken;
        private String startAfter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ListBucketResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ListBucketResultV2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ListBucketResultBase instance;
            long bits = 0L;
            if (object instanceof ListBucketResultBase) {
                instance = (ListBucketResultBase)object;
                if ((bits & 1L) == 0L) {
                    this.isTruncated(instance.isTruncated());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.maxKeys(instance.maxKeys());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllContents(instance.contents());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String prefixValue = instance.prefix();
                    if (prefixValue != null) {
                        this.prefix(prefixValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    String encodingTypeValue = instance.encodingType();
                    if (encodingTypeValue != null) {
                        this.encodingType(encodingTypeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllCommonPrefixes(instance.commonPrefixes());
                    bits |= 0x40L;
                }
            }
            if (object instanceof ListBucketResultV2) {
                String continuationTokenValue;
                String startAfterValue;
                instance = (ListBucketResultV2)object;
                if ((bits & 1L) == 0L) {
                    this.isTruncated(instance.isTruncated());
                    bits |= 1L;
                }
                this.keyCount(instance.keyCount());
                String nextContinuationTokenValue = instance.nextContinuationToken();
                if (nextContinuationTokenValue != null) {
                    this.nextContinuationToken(nextContinuationTokenValue);
                }
                if ((bits & 2L) == 0L) {
                    this.maxKeys(instance.maxKeys());
                    bits |= 2L;
                }
                if ((startAfterValue = instance.startAfter()) != null) {
                    this.startAfter(startAfterValue);
                }
                if ((bits & 4L) == 0L) {
                    this.addAllContents(instance.contents());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String prefixValue = instance.prefix();
                    if (prefixValue != null) {
                        this.prefix(prefixValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    String encodingTypeValue = instance.encodingType();
                    if (encodingTypeValue != null) {
                        this.encodingType(encodingTypeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllCommonPrefixes(instance.commonPrefixes());
                    bits |= 0x40L;
                }
                if ((continuationTokenValue = instance.continuationToken()) != null) {
                    this.continuationToken(continuationTokenValue);
                }
            }
        }

        @Override
        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Prefix")
        @CanIgnoreReturnValue
        public final Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        @JsonProperty(value="MaxKeys")
        @CanIgnoreReturnValue
        public final Builder maxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="EncodingType")
        @CanIgnoreReturnValue
        public final Builder encodingType(@Nullable String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        @JsonProperty(value="IsTruncated")
        @CanIgnoreReturnValue
        public final Builder isTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addContents(S3Object element) {
            this.contents.add(Objects.requireNonNull(element, "contents element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addContents(S3Object ... elements) {
            for (S3Object element : elements) {
                this.contents.add(Objects.requireNonNull(element, "contents element"));
            }
            return this;
        }

        @JsonProperty(value="Contents")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder contents(Iterable<? extends S3Object> elements) {
            this.contents.clear();
            return this.addAllContents((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllContents(Iterable<? extends S3Object> elements) {
            for (S3Object s3Object : elements) {
                this.contents.add(Objects.requireNonNull(s3Object, "contents element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCommonPrefixes(Prefix element) {
            this.commonPrefixes.add(Objects.requireNonNull(element, "commonPrefixes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCommonPrefixes(Prefix ... elements) {
            for (Prefix element : elements) {
                this.commonPrefixes.add(Objects.requireNonNull(element, "commonPrefixes element"));
            }
            return this;
        }

        @JsonProperty(value="CommonPrefixes")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder commonPrefixes(Iterable<? extends Prefix> elements) {
            this.commonPrefixes.clear();
            return this.addAllCommonPrefixes((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllCommonPrefixes(Iterable<? extends Prefix> elements) {
            for (Prefix prefix : elements) {
                this.commonPrefixes.add(Objects.requireNonNull(prefix, "commonPrefixes element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ContinuationToken")
        @CanIgnoreReturnValue
        public final Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        @JsonProperty(value="KeyCount")
        @CanIgnoreReturnValue
        public final Builder keyCount(int keyCount) {
            this.keyCount = keyCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @JsonProperty(value="NextContinuationToken")
        @CanIgnoreReturnValue
        public final Builder nextContinuationToken(@Nullable String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        @Override
        @JsonProperty(value="StartAfter")
        @CanIgnoreReturnValue
        public final Builder startAfter(@Nullable String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        @Override
        public ImmutableListBucketResultV2 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableListBucketResultV2(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, ImmutableListBucketResultV2.createUnmodifiableList(true, this.contents), ImmutableListBucketResultV2.createUnmodifiableList(true, this.commonPrefixes), this.continuationToken, this.keyCount, this.nextContinuationToken, this.startAfter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxKeys");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isTruncated");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("keyCount");
            }
            return "Cannot build ListBucketResultV2, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ListBucketResultV2", generator="Immutables")
    static final class Json
    implements ListBucketResultV2 {
        @JsonIgnore
        String name;
        @JsonIgnore
        String prefix;
        @JsonIgnore
        int maxKeys;
        @JsonIgnore
        boolean maxKeysIsSet;
        @JsonIgnore
        String encodingType;
        @JsonIgnore
        boolean isTruncated;
        @JsonIgnore
        boolean isTruncatedIsSet;
        @JsonIgnore
        List<S3Object> contents = Collections.emptyList();
        @JsonIgnore
        List<Prefix> commonPrefixes = Collections.emptyList();
        @JsonIgnore
        String continuationToken;
        @JsonIgnore
        int keyCount;
        @JsonIgnore
        boolean keyCountIsSet;
        @JsonIgnore
        String nextContinuationToken;
        @JsonIgnore
        String startAfter;

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Prefix")
        public void setPrefix(@Nullable String prefix) {
            this.prefix = prefix;
        }

        @JsonProperty(value="MaxKeys")
        public void setMaxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            this.maxKeysIsSet = true;
        }

        @JsonProperty(value="EncodingType")
        public void setEncodingType(@Nullable String encodingType) {
            this.encodingType = encodingType;
        }

        @JsonProperty(value="IsTruncated")
        public void setIsTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            this.isTruncatedIsSet = true;
        }

        @JsonProperty(value="Contents")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setContents(List<S3Object> contents) {
            this.contents = contents;
        }

        @JsonProperty(value="CommonPrefixes")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setCommonPrefixes(List<Prefix> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @JsonProperty(value="ContinuationToken")
        public void setContinuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @JsonProperty(value="KeyCount")
        public void setKeyCount(int keyCount) {
            this.keyCount = keyCount;
            this.keyCountIsSet = true;
        }

        @JsonProperty(value="NextContinuationToken")
        public void setNextContinuationToken(@Nullable String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        @JsonProperty(value="StartAfter")
        public void setStartAfter(@Nullable String startAfter) {
            this.startAfter = startAfter;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String prefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int maxKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encodingType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTruncated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<S3Object> contents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Prefix> commonPrefixes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String continuationToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int keyCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextContinuationToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String startAfter() {
            throw new UnsupportedOperationException();
        }
    }
}

