/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.Bucket;

@Generated(from="Bucket", generator="Immutables")
public final class ImmutableBucket
implements Bucket {
    private final String name;
    private final String creationDate;

    private ImmutableBucket(String name, String creationDate) {
        this.name = name;
        this.creationDate = creationDate;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="CreationDate")
    public String creationDate() {
        return this.creationDate;
    }

    public final ImmutableBucket withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableBucket(newValue, this.creationDate);
    }

    public final ImmutableBucket withCreationDate(String value) {
        String newValue = Objects.requireNonNull(value, "creationDate");
        if (this.creationDate.equals(newValue)) {
            return this;
        }
        return new ImmutableBucket(this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBucket && this.equalsByValue((ImmutableBucket)another);
    }

    private boolean equalsByValue(ImmutableBucket another) {
        return this.name.equals(another.name) && this.creationDate.equals(another.creationDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.creationDate.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Bucket").omitNullValues().add("name", (Object)this.name).add("creationDate", (Object)this.creationDate).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBucket fromJson(Json json) {
        Builder builder = ImmutableBucket.builder();
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._creationDate != null) {
            builder.creationDate(json._creationDate);
        }
        return builder.build();
    }

    public static ImmutableBucket copyOf(Bucket instance) {
        if (instance instanceof ImmutableBucket) {
            return (ImmutableBucket)instance;
        }
        return ImmutableBucket.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bucket", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CREATION_DATE = 2L;
        private long initBits = 3L;
        private String name;
        private String creationDate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bucket instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.creationDate(instance.creationDate());
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="CreationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(String creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBucket build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBucket(this.name, this.creationDate);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("creationDate");
            }
            return "Cannot build Bucket, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Bucket", generator="Immutables")
    static final class Json
    implements Bucket {
        @JsonIgnore
        String _name;
        @JsonIgnore
        String _creationDate;

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="CreationDate")
        public void setCreationDate(String creationDate) {
            this._creationDate = creationDate;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String creationDate() {
            throw new UnsupportedOperationException();
        }
    }
}

